/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.foxgenesis.util.ResourceUtils;
import net.foxgenesis.util.resource.ModuleResource;
import net.foxgenesis.watame.ExitCode;
import net.foxgenesis.watame.Main;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatameBotSettings {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    @Nonnull
    public final Path configurationPath;
    private final INIConfiguration config;
    private final String token;

    WatameBotSettings(@Nonnull Path configPath) throws Exception {
        this(configPath, null);
    }

    WatameBotSettings(@Nonnull Path configPath, @Nullable Path tokenFile2) throws Exception {
        Path tokenFile;
        this.configurationPath = Objects.requireNonNull(configPath);
        if (!WatameBotSettings.isValidDirectory(configPath)) {
            throw new IOException("Invalid configuration directory");
        }
        this.config = ResourceUtils.loadINI(new ModuleResource(this.getClass().getModule(), "/META-INF/defaults/watamebot.ini"), this.configurationPath, "watamebot.ini");
        Path path = tokenFile = tokenFile2 == null ? Path.of(this.config.getString("Token.tokenFile", "token.txt"), new String[0]) : configPath.resolve(tokenFile2);
        if (!WatameBotSettings.isValidFile(tokenFile)) {
            throw new SettingsException("Invalid token file");
        }
        this.token = WatameBotSettings.readToken(tokenFile);
        logger.info("Checking token");
        if (!WatameBotSettings.isValidToken(this.token)) {
            ExitCode.INVALID_TOKEN.programExit("Invalid token");
        }
    }

    public ImmutableConfiguration getConfiguration() {
        return this.config;
    }

    String getToken() {
        return this.token;
    }

    private static String readToken(Path filepath) throws Exception {
        return Files.lines(filepath).filter(s -> !s.startsWith("#")).map(String::trim).findFirst().orElse("");
    }

    private static boolean isValidToken(String token) throws Exception {
        return token != null && !token.isBlank();
    }

    private static boolean isValidDirectory(Path path) throws SettingsException {
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (Files.exists(path, new LinkOption[0]) && WatameBotSettings.check(Files.isDirectory(path, new LinkOption[0]), "Configuration path must be a directory!")) {
            return WatameBotSettings.check(Files.isReadable(path), "Unable to read from configuration directory!") && WatameBotSettings.check(Files.isWritable(path), "Unable to write to configuration directory!");
        }
        return false;
    }

    private static boolean isValidFile(Path path) throws SettingsException {
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (Files.exists(path, new LinkOption[0]) && WatameBotSettings.check(Files.isRegularFile(path, new LinkOption[0]), "Token file must be a regular file!")) {
            return WatameBotSettings.check(Files.isReadable(path), "Unable to read from token file!");
        }
        return false;
    }

    private static boolean check(boolean toTest, String err) throws SettingsException {
        if (toTest) {
            return true;
        }
        throw new SettingsException(err);
    }

    public static class SettingsException
    extends Exception {
        private static final long serialVersionUID = 5228408925488573319L;

        public SettingsException(String msg) {
            super(msg);
        }
    }
}

