/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import net.foxgenesis.util.SingleInstanceUtil;
import net.foxgenesis.util.resource.ModuleResource;
import net.foxgenesis.watame.ExitCode;
import net.foxgenesis.watame.WatameBot;
import net.foxgenesis.watame.WatameBotSettings;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static WatameBotSettings settings;

    public static void main(String[] args) throws Exception {
        MDC.put((String)"watame.status", (String)"START-UP");
        Path configPath = Path.of("config/", new String[0]);
        String logLevel = null;
        Path tokenFile = null;
        int length = args.length;
        block10: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            switch (arg.toLowerCase()) {
                case "-config": {
                    if (!Main.hasArg(i, length, "-config")) continue block10;
                    configPath = Path.of(StringUtils.strip((String)args[++i], (String)"\""), new String[0]);
                    continue block10;
                }
                case "-loglevel": {
                    if (!Main.hasArg(i, length, "-loglevel")) continue block10;
                    String tmp = args[++i];
                    if (!StringUtils.equalsAnyIgnoreCase((CharSequence)tmp, (CharSequence[])new CharSequence[]{"info", "debug", "trace"})) continue block10;
                    logLevel = tmp.toUpperCase();
                    logger.info("Setting logging level to: " + logLevel);
                    continue block10;
                }
                case "-tokenfile": {
                    if (!Main.hasArg(i, length, "-tokenfile")) continue block10;
                    tokenFile = Path.of(StringUtils.strip((String)args[++i], (String)"\""), new String[0]);
                }
            }
        }
        settings = new WatameBotSettings(configPath, tokenFile);
        ImmutableConfiguration config = settings.getConfiguration();
        if (config.getBoolean("Runtime.ansiConsole", true)) {
            logger.info("Installing ANSI console");
            AnsiConsole.systemInstall();
        }
        if (logLevel == null) {
            logLevel = config.getString("Logging.logLevel", "info");
        }
        System.setProperty("LOG_LEVEL", logLevel);
        Main.restartLogging();
        if (config.getBoolean("SingleInstance.enabled", true)) {
            Main.getLock(config.getInt("SingleInstance.retries", 5));
        }
        logger.info("Checking multi-threading");
        logger.info("CPU Cores: {}  |  Parallelism: {}  |  CommonPool Common Parallelism: {}", new Object[]{Runtime.getRuntime().availableProcessors(), ForkJoinPool.commonPool().getParallelism(), ForkJoinPool.getCommonPoolParallelism()});
        WatameBot watame = WatameBot.INSTANCE;
        System.out.println();
        watame.start();
    }

    private static boolean hasArg(int index, int length, String argName) {
        if (index + 1 > length) {
            logger.error("Missing argument for ", (Object)argName);
            System.exit(1);
            return false;
        }
        return true;
    }

    private static boolean getLock(int retries) throws Exception {
        try {
            SingleInstanceUtil.waitAndGetLock(retries);
            return true;
        }
        catch (SingleInstanceUtil.SingleInstanceLockException e) {
            ExitCode.INSTANCE_ALREADY_RUNNING.programExit("Another instance is already running! Exiting...");
            return false;
        }
    }

    private static void restartLogging() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            try (InputStream in = new ModuleResource("watamebot", "/logback.xml").openStream();){
                configurator.doConfigure(in);
            }
        }
        catch (JoranException | IOException throwable) {
            // empty catch block
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
    }

    @Nonnull
    static WatameBotSettings getSettings() {
        return settings;
    }
}

