/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame;

import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.foxgenesis.database.DatabaseManager;
import net.foxgenesis.watame.WatameBot;
import net.foxgenesis.watame.plugin.EventStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(Context.class);
    private final WatameBot bot;
    private final EventStore eventStore;
    private final ExecutorService executor;

    public Context(@Nonnull WatameBot bot, @Nonnull JDABuilder builder, @Nonnull ExecutorService executor) {
        this.bot = Objects.requireNonNull(bot);
        this.executor = Objects.requireNonNull(executor);
        this.eventStore = new EventStore(builder);
    }

    @Nonnull
    public DatabaseManager getDatabaseManager() {
        return (DatabaseManager)this.bot.getDatabaseManager();
    }

    @Nonnull
    public EventStore getEventRegister() {
        return this.eventStore;
    }

    @Nonnull
    public ExecutorService getAsynchronousExecutor() {
        return this.executor;
    }

    @Nullable
    public JDA getJDA() {
        return this.bot.getJDA();
    }

    @Nonnull
    public WatameBot.State getState() {
        return this.bot.getState();
    }

    void onJDABuilder(JDA jda) {
        this.eventStore.setJDA(jda);
    }

    @Override
    public void close() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                logger.warn("Timed out waiting for plugin pool shutdown. Continuing shutdown...");
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

