/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property.database;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.foxgenesis.property.CachedObject;
import net.foxgenesis.property.database.SQLConfigurationDatabase;

public class CachedSQLConfigurationDatabase
extends SQLConfigurationDatabase {
    private final ConcurrentHashMap<String, CachedObject<String>> cache = new ConcurrentHashMap();
    private final long cacheTimeMilli;

    public CachedSQLConfigurationDatabase(@Nonnull String name, @Nonnull String database, @Nonnull String table, long cacheTimeMilli) {
        super(name, database, table);
        this.cacheTimeMilli = cacheTimeMilli;
    }

    @Override
    protected boolean putInternal(@Nonnull Long lookup, @Nonnull String key, @Nonnull String value) {
        this.getCached(lookup, key).set(value);
        return super.putInternal(lookup, key, value);
    }

    @Override
    protected Optional<String> getInternal(@Nonnull Long lookup, @Nonnull String key) {
        return Optional.ofNullable(this.getCached(lookup, key).get());
    }

    @Nonnull
    private CachedObject<String> getCached(long lookup, @Nonnull String key) {
        return this.cache.computeIfAbsent(lookup + ":" + key, k -> new CachedObject<String>(() -> super.getInternal(lookup, key).orElse(null), this.cacheTimeMilli));
    }

    public long getCacheTime() {
        return this.cacheTimeMilli;
    }

    @Override
    public synchronized void close() {
        super.close();
        this.cache.clear();
    }
}

