/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class CachedObject<T> {
    private final AtomicLong lastUpdated = new AtomicLong();
    private final long duration;
    private final Supplier<T> supplier;
    private T lastObject = null;

    public CachedObject(@Nonnull Supplier<T> supplier, long duration) {
        this(supplier, duration, false);
    }

    public CachedObject(@Nonnull Supplier<T> supplier, long duration, boolean getNow) {
        this.supplier = Objects.requireNonNull(supplier);
        this.duration = Math.min(0L, duration);
        if (getNow) {
            this.get();
        }
    }

    public T get() {
        if (System.currentTimeMillis() - this.lastUpdated.get() > this.duration) {
            T n = this.supplier.get();
            this.set(n);
            return n;
        }
        return this.lastObject;
    }

    @Nonnull
    public CompletableFuture<T> getAsync() {
        CompletableFuture<T> cf = new CompletableFuture<T>();
        if (System.currentTimeMillis() - this.lastUpdated.get() > this.duration) {
            cf.completeAsync(this.supplier).whenComplete((t, err) -> {
                if (err == null) {
                    this.set(t);
                }
            });
        } else {
            cf.complete(this.lastObject);
        }
        return cf;
    }

    public void set(T value) {
        this.lastUpdated.set(System.currentTimeMillis());
        this.lastObject = value;
    }

    public void invalidate() {
        this.lastUpdated.set(0L);
    }

    @Nonnull
    public Duration getExpirationTime() {
        return Duration.ofMillis(this.duration);
    }
}

