/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.sql;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.events.Event;
import net.foxgenesis.config.KVPFile;
import net.foxgenesis.util.MethodTimer;
import net.foxgenesis.util.ResourceUtils;
import net.foxgenesis.watame.Constants;
import net.foxgenesis.watame.ExitCode;
import net.foxgenesis.watame.sql.GuildData;
import net.foxgenesis.watame.sql.IGuildData;
import net.foxgenesis.watame.sql.IGuildDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@Deprecated(forRemoval=true)
public class DataManager
implements IGuildDataProvider,
AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger((String)"Database");
    static final Logger sqlLogger = LoggerFactory.getLogger((String)"SQLInfo");
    static final Marker SQL_MARKER = MarkerFactory.getMarker((String)"SQL");
    static final Marker UPDATE_MARKER = MarkerFactory.getMarker((String)"SQL_UPDATE");
    static final Marker QUERY_MARKER = MarkerFactory.getMarker((String)"SQL_QUERY");
    private final ConcurrentHashMap<Long, GuildData> data = new ConcurrentHashMap();
    private final File databaseFolder;
    private boolean allDataReady;
    private Connection connectionHandler;
    private final ConcurrentHashMap<String, PreparedStatement> registeredStatements = new ConcurrentHashMap();

    private DataManager() {
        this(new File("repo"));
    }

    private DataManager(@Nonnull File folder) {
        this.createDatabaseFolder(folder);
        this.databaseFolder = folder;
    }

    public void connect() throws SQLException, UnsupportedOperationException, IOException {
        String connectionPath = this.databaseFolder.getPath() + File.separator + "database.db";
        logger.trace("Database path: {}", (Object)connectionPath);
        logger.trace("Attempting connection to database");
        this.connectionHandler = DriverManager.getConnection("jdbc:sqlite:" + connectionPath);
        logger.info("Connected to SQL database");
        this.setupDatabase(Constants.DATABASE_SETUP_FILE);
        this.initalizeOperations(Constants.DATABASE_OPERATIONS_FILE);
    }

    public void addGuild(@Nonnull Guild guild) {
        Objects.requireNonNull(guild);
        logger.debug("Loading guild ({})[{}]", (Object)guild.getName(), (Object)guild.getIdLong());
        if (this.allDataReady) {
            this.retrieveData(guild);
        }
        logger.trace("Guild loaded ({})[{}]", (Object)guild.getName(), (Object)guild.getIdLong());
    }

    public void removeGuild(@Nonnull Guild guild) {
        Objects.requireNonNull(guild);
        logger.debug("Removing guild ({})[{}]", (Object)guild.getName(), (Object)guild.getIdLong());
        try {
            this.data.remove(guild.getIdLong()).close();
            logger.trace("Guild REMOVED ({})[{}]", (Object)guild.getName(), (Object)guild.getIdLong());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void retrieveDatabaseData(@Nonnull JDA jda) {
        this.allDataReady = true;
    }

    private void getAllGuildData() {
        logger.trace("Getting all guild data...");
        logger.info("Retrieved initial guild data in " + MethodTimer.runFormatMS(() -> {
            PreparedStatement s = this.getAndAssertStatement("guild_data_get");
            sqlLogger.trace(QUERY_MARKER, s.toString());
            try (ResultSet set = s.executeQuery();){
                while (set.next()) {
                    long id = set.getLong("GuildID");
                    if (!this.data.containsKey(id)) continue;
                    logger.debug("Adding data for guild {}", (Object)id);
                    this.data.get(id).setData(set);
                }
            }
            catch (SQLException e) {
                sqlLogger.error(QUERY_MARKER, "Error while getting initial guild data", (Throwable)e);
            }
        }));
    }

    private void retrieveData(@Nonnull Guild guild) {
        Objects.requireNonNull(guild);
        logger.trace("Retrieved guild data for {} in: " + MethodTimer.runFormatMS(() -> {
            PreparedStatement s = this.getAndAssertStatement("guild_data_get_id");
            try {
                s.setString(1, guild.getId());
                sqlLogger.trace(QUERY_MARKER, s.toString());
                try (ResultSet set = s.executeQuery();){
                    long id = set.getLong("GuildID");
                    if (id != 0L && this.data.containsKey(id)) {
                        this.data.get(id).setData(set);
                    } else {
                        logger.warn("Guild ({})[{}] is missing in database! Attempting to insert and retrieve...", (Object)guild.getName(), (Object)guild.getIdLong());
                        this.insertGuildInDatabase(guild);
                        this.retrieveData(guild);
                    }
                }
            }
            catch (SQLException e) {
                sqlLogger.error(QUERY_MARKER, "Error while getting guild data", (Throwable)e);
            }
        }), (Object)guild.getName());
    }

    @Override
    @Nullable
    public IGuildData getDataForGuild(@Nonnull Guild guild) {
        Objects.requireNonNull(guild);
        if (!this.isReady()) {
            throw new UnsupportedOperationException("Data not ready yet");
        }
        if (!this.data.containsKey(guild.getIdLong())) {
            logger.warn("Attempted to get non existant data for guild {}. Attempting to insert and retrieve data", (Object)guild.getId());
            this.insertGuildInDatabase(guild);
            this.retrieveData(guild);
        }
        return this.data.get(guild.getIdLong());
    }

    private void insertGuildInDatabase(@Nonnull Guild guild) {
        Objects.requireNonNull(guild);
        logger.trace("Inserted new row for guild {} in: " + MethodTimer.runFormatMS(() -> {
            PreparedStatement st = this.getAndAssertStatement("guild_data_insert");
            try {
                long guildID = guild.getIdLong();
                st.setLong(1, guildID);
                sqlLogger.trace(UPDATE_MARKER, st.toString());
                st.executeUpdate();
            }
            catch (SQLException e) {
                sqlLogger.error(QUERY_MARKER, "Error while inserting new guild", (Throwable)e);
            }
        }), (Object)guild.getName());
    }

    @Override
    public boolean isReady() {
        return this.allDataReady;
    }

    public boolean isConnectionValid() {
        try {
            return this.connectionHandler != null && this.connectionHandler.isValid(1000);
        }
        catch (SQLException e) {
            logger.error("Error while checking database connection", (Throwable)e);
            return false;
        }
    }

    private void createDatabaseFolder(@Nonnull File folder) {
        Objects.requireNonNull(folder);
        if (folder.exists()) {
            if (folder.isFile()) {
                throw new IllegalArgumentException("Selected file is not a directory!");
            }
        } else {
            logger.info("Repo folder does not exist! Creating...");
            folder.mkdirs();
        }
    }

    private void setupDatabase(@Nonnull ResourceUtils.ModuleResource resource) throws IOException, UnsupportedOperationException {
        String[] lines;
        if (!this.isConnectionValid()) {
            throw new UnsupportedOperationException("Not connected to database!");
        }
        logger.trace("Reading lines from SQL file");
        for (String line : lines = ResourceUtils.toSplitString(Objects.requireNonNull(resource, "Resource must not be null!").openStream())) {
            try (Statement statement = this.connectionHandler.createStatement();){
                sqlLogger.trace("Executing SQL statement: " + line);
                statement.execute(line);
            }
            catch (SQLException e) {
                ExitCode.DATABASE_SETUP_ERROR.programExit(e);
                return;
            }
        }
    }

    private void initalizeOperations(@Nonnull ResourceUtils.ModuleResource resource) throws IOException {
        KVPFile kvp = new KVPFile(Objects.requireNonNull(resource, "Resource must not be null!").openStream());
        kvp.forEach((key, value) -> {
            if (this.registeredStatements.containsKey(key)) {
                logger.error("Statement '{}' already exists! Skipping...", key);
            } else {
                try {
                    this.registerStatement((String)key, (String)value);
                }
                catch (SQLException e) {
                    ExitCode.DATABASE_STATEMENT_ERROR.programExit(e);
                    return;
                }
            }
        });
    }

    private void registerStatement(String id, @Nonnull String statement) throws SQLException {
        Objects.requireNonNull(statement);
        if (this.registeredStatements.containsKey(id)) {
            throw new IllegalArgumentException("Statement '" + id + "' already exists!");
        }
        if (!this.isConnectionValid()) {
            throw new UnsupportedOperationException("Not connected to database!");
        }
        sqlLogger.trace("Creating PreparedStatement {} : {}", (Object)id, (Object)statement);
        PreparedStatement preStatement = this.connectionHandler.prepareStatement(statement);
        this.registeredStatements.put(id, preStatement);
    }

    PreparedStatement getAndAssertStatement(@Nonnull String id) {
        Objects.requireNonNull(id);
        if (this.registeredStatements.containsKey(id)) {
            return this.registeredStatements.get(id);
        }
        ExitCode.DATABASE_STATEMENT_MISSING.programExit(String.format("Statement with id '%s' is not registered!", id));
        return null;
    }

    @Override
    public void close() throws Exception {
        if (this.connectionHandler != null && !this.connectionHandler.isClosed()) {
            this.closeStatements();
            logger.info("Disconnecting from database");
            this.connectionHandler.close();
        } else {
            logger.warn("Attempted to close already closed sql connection");
        }
    }

    private void closeStatements() {
        logger.trace("Closing open statements");
        this.registeredStatements.entrySet().stream().forEach(e -> {
            try {
                logger.trace("Closing statement " + (String)e.getKey());
                ((PreparedStatement)e.getValue()).close();
            }
            catch (SQLException e1) {
                logger.error("Failed to close statement '" + (String)e.getKey() + "'!", (Throwable)e1);
            }
        });
        logger.trace("All statements have been closed");
        this.registeredStatements.clear();
    }

    static {
        UPDATE_MARKER.add(SQL_MARKER);
        QUERY_MARKER.add(SQL_MARKER);
    }

    public static class DatabaseLoadedEvent
    extends Event {
        public final IGuildDataProvider dataManager;

        public DatabaseLoadedEvent(JDA api, IGuildDataProvider dataManager) {
            super(api);
            this.dataManager = dataManager;
        }
    }
}

