/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.plugin;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.requests.restaction.CommandListUpdateAction;
import net.dv8tion.jda.internal.utils.IOUtil;
import net.foxgenesis.util.CompletableFutureUtils;
import net.foxgenesis.watame.Context;
import net.foxgenesis.watame.ProtectedJDABuilder;
import net.foxgenesis.watame.WatameBot;
import net.foxgenesis.watame.plugin.Plugin;
import net.foxgenesis.watame.plugin.SeverePluginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class PluginHandler<T extends Plugin>
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(PluginHandler.class);
    private final ConcurrentHashMap<String, T> plugins = new ConcurrentHashMap();
    @Nonnull
    private final ServiceLoader<T> loader;
    @Nonnull
    private final ModuleLayer layer;
    @Nonnull
    private final Class<T> pluginClass;
    @Nonnull
    private final ForkJoinPool pluginExecutor;
    @Nonnull
    private final Context context;

    public PluginHandler(Context context, ModuleLayer layer, Class<T> pluginClass) {
        this.context = Objects.requireNonNull(context);
        this.layer = Objects.requireNonNull(layer);
        this.pluginClass = Objects.requireNonNull(pluginClass);
        this.loader = ServiceLoader.load(layer, pluginClass);
        this.pluginExecutor = ForkJoinPool.commonPool();
    }

    public void loadPlugins() {
        logger.info("Starting...");
        this.loader.stream().map(provider -> (Plugin)provider.get()).forEach(plugin -> this.plugins.put(plugin.name, plugin));
        logger.debug("Found {} plugins", (Object)this.plugins.size());
    }

    @Nonnull
    public CompletableFuture<Void> preInit() {
        logger.debug("Calling plugin pre-initialization async");
        return this.forEachPlugin(Plugin::preInit, null);
    }

    @Nonnull
    public CompletableFuture<Void> init(ProtectedJDABuilder builder) {
        logger.debug("Calling plugin initialization async");
        return this.forEachPlugin(plugin -> plugin.init(builder), null);
    }

    @Nonnull
    public CompletableFuture<Void> postInit(WatameBot watamebot) {
        logger.debug("Calling plugin post-initialization async");
        return this.forEachPlugin(plugin -> plugin.postInit(watamebot), null);
    }

    @Nonnull
    public CompletableFuture<Void> onReady(WatameBot watamebot) {
        logger.debug("Calling plugin on ready async");
        return this.forEachPlugin(plugin -> plugin.onReady(watamebot), null);
    }

    @Nonnull
    public CommandListUpdateAction updateCommands(CommandListUpdateAction action) {
        this.plugins.values().stream().filter(p -> p.providesCommands).map(Plugin::getCommands).forEach(arg_0 -> ((CommandListUpdateAction)action).addCommands(arg_0));
        return action;
    }

    @Nonnull
    private CompletableFuture<Void> forEachPlugin(Consumer<? super T> task, @Nullable Predicate<Plugin> filter) {
        if (filter == null) {
            filter = p -> true;
        }
        return CompletableFutureUtils.allOf(this.plugins.values().stream().filter(filter).map(plugin -> CompletableFuture.runAsync(() -> task.accept(plugin), this.pluginExecutor).exceptionally(error -> {
            this.pluginError((T)plugin, (Throwable)error);
            return null;
        })));
    }

    private void unloadPlugin(T plugin) {
        logger.trace("Unloading {}", plugin.getClass());
        this.plugins.remove(((Plugin)plugin).name);
        IOUtil.silentClose(plugin);
        if (((Plugin)plugin).needsDatabase) {
            logger.info("Unloading database connections from ", (Object)((Plugin)plugin).getDisplayInfo());
            this.context.getDatabaseManager().unload((Plugin)plugin);
        }
        logger.warn(((Plugin)plugin).getDisplayInfo() + " unloaded");
    }

    private void pluginError(T plugin, Throwable error) {
        MDC.put((String)"watame.status", (String)this.context.getState().name());
        Throwable temp = error;
        if (error instanceof CompletionException && error.getCause() instanceof SeverePluginException) {
            temp = error.getCause();
        }
        if (temp instanceof SeverePluginException) {
            SeverePluginException pluginException = (SeverePluginException)temp;
            Marker m = MarkerFactory.getMarker((String)(pluginException.isFatal() ? "FATAL" : "SEVERE"));
            logger.error(m, "Exception in " + ((Plugin)plugin).friendlyName, (Throwable)pluginException);
            if (pluginException.isFatal()) {
                this.unloadPlugin(plugin);
            }
        } else {
            logger.error("Error in " + ((Plugin)plugin).getDisplayInfo(), error);
        }
    }

    @Override
    public void close() throws IOException {
        this.loader.reload();
        logger.debug("Closing all pugins");
        this.plugins.values().stream().filter(plugin -> plugin.needsDatabase).forEach(plugin -> this.context.getDatabaseManager().unload((Plugin)plugin));
        this.plugins.values().forEach(plugin -> IOUtil.silentClose((AutoCloseable)plugin));
        this.pluginExecutor.shutdown();
        if (!this.pluginExecutor.awaitQuiescence(30L, TimeUnit.SECONDS)) {
            logger.warn("Timed out waiting for plugin pool shutdown. Continuing shutdown...");
            this.pluginExecutor.shutdownNow();
        }
        this.plugins.clear();
    }

    public boolean isPluginPresent(String identifier) {
        return this.plugins.containsKey(identifier);
    }

    public Plugin getPlugin(String identifier) {
        return (Plugin)this.plugins.get(identifier);
    }

    @Nonnull
    public Class<T> getPluginClass() {
        return this.pluginClass;
    }

    @Nonnull
    public ModuleLayer getModuleLayer() {
        return this.layer;
    }
}

