/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.foxgenesis.util.ResourceUtils;
import net.foxgenesis.watame.ProtectedJDABuilder;
import net.foxgenesis.watame.WatameBot;
import net.foxgenesis.watame.plugin.PluginConfiguration;
import net.foxgenesis.watame.plugin.SeverePluginException;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Plugin
implements AutoCloseable {
    @Nonnull
    private static final Path CONFIG_PATH = Paths.get("config", new String[0]);
    @Nonnull
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nonnull
    private final HashMap<String, PropertiesConfiguration> configs = new HashMap();
    @Nonnull
    private final HashMap<String, CommandData> commands = new HashMap();
    @Nonnull
    public final Path configurationPath;
    @Nonnull
    public final String name;
    @Nonnull
    public final String friendlyName;
    @Nonnull
    public final String description;
    @Nonnull
    public final Runtime.Version version;
    public final boolean providesCommands;
    public final boolean needsDatabase;

    public Plugin() throws SeverePluginException {
        Class<?> c = this.getClass();
        Module module = c.getModule();
        if (!module.isNamed()) {
            throw new SeverePluginException("Plugin is not in a named module!");
        }
        try (InputStream stream = module.getResourceAsStream("/plugin.properties");){
            Properties properties = new Properties();
            properties.load(stream);
            this.name = Objects.requireNonNull(properties.getProperty("name"), "name must not be null!");
            this.friendlyName = Objects.requireNonNull(properties.getProperty("friendlyName"), "friendlyName must not be null!");
            this.version = Runtime.Version.parse(Objects.requireNonNull(properties.getProperty("version"), "version must not be null!"));
            this.description = properties.getProperty("description", "No description provided");
            this.providesCommands = properties.getProperty("providesCommands", "false").equalsIgnoreCase("true");
            this.needsDatabase = properties.getProperty("needsDatabase", "false").equalsIgnoreCase("true");
            this.configurationPath = CONFIG_PATH.resolve(this.name);
            CompletableFuture.runAsync(() -> this.onPropertiesLoaded(properties));
        }
        catch (Exception e) {
            throw new SeverePluginException(e, true);
        }
        if (c.isAnnotationPresent(PluginConfiguration.class)) {
            PluginConfiguration[] configDeclares;
            for (PluginConfiguration pluginConfig : configDeclares = (PluginConfiguration[])c.getDeclaredAnnotationsByType(PluginConfiguration.class)) {
                String id = pluginConfig.identifier();
                if (this.configs.containsKey(id)) continue;
                try {
                    this.logger.debug("Loading configuration for {}", (Object)pluginConfig.outputFile());
                    PropertiesConfiguration config = ResourceUtils.loadConfig(new ResourceUtils.ModuleResource(module, pluginConfig.defaultFile()), this.configurationPath, pluginConfig.outputFile());
                    this.configs.put(id, config);
                    CompletableFuture.runAsync(() -> this.onConfigurationLoaded(id, config));
                }
                catch (IOException | ConfigurationException e) {
                    throw new SeverePluginException(e, false);
                }
            }
        }
    }

    protected boolean hasConfiguration(String identifier) {
        return this.configs.containsKey(identifier);
    }

    @Nullable
    protected PropertiesConfiguration getConfiguration(String identifier) {
        return this.configs.getOrDefault(identifier, null);
    }

    protected boolean hasCommandData(String command) {
        return this.commands.containsKey(command);
    }

    @Nullable
    protected CommandData getCommandData(String command) {
        return this.commands.getOrDefault(command, null);
    }

    @Nonnull
    protected Collection<CommandData> getCommands() {
        return Collections.unmodifiableCollection(this.commands.values());
    }

    protected abstract void onPropertiesLoaded(Properties var1);

    protected abstract void onConfigurationLoaded(String var1, PropertiesConfiguration var2);

    protected abstract void preInit() throws SeverePluginException;

    protected abstract void init(ProtectedJDABuilder var1) throws SeverePluginException;

    protected abstract void postInit(WatameBot var1) throws SeverePluginException;

    protected abstract void onReady(WatameBot var1) throws SeverePluginException;

    public String getDisplayInfo() {
        return this.friendlyName + " v" + this.version;
    }

    public String toString() {
        return "Plugin [name=" + this.name + ", friendlyName=" + this.friendlyName + ", description=" + this.description + ", version=" + this.version + ", providesCommands=" + this.providesCommands + ", needsDatabase=" + this.needsDatabase + ", configurationPath=" + this.configurationPath + "]";
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Plugin other = (Plugin)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version);
    }

    static {
        try {
            Files.createDirectories(CONFIG_PATH, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

