/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.plugin;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.foxgenesis.watame.plugin.IEventStore;
import net.foxgenesis.watame.plugin.Plugin;

public class EventStore
implements IEventStore {
    private final ConcurrentHashMap<Plugin, Set<Object>> store = new ConcurrentHashMap();
    private final JDABuilder builder;
    private JDA jda;

    public EventStore(JDABuilder builder) {
        this.builder = Objects.requireNonNull(builder);
    }

    public void register(Plugin plugin) {
        this.store.putIfAbsent(plugin, new HashSet());
    }

    public synchronized void unregister(Plugin plugin) {
        Objects.requireNonNull(plugin);
        Set<Object> objs = this.store.remove(plugin);
        if (objs != null && !objs.isEmpty()) {
            this.builder.removeEventListeners(objs.toArray());
            if (this.jda != null) {
                this.jda.removeEventListener(objs.toArray());
            }
            objs.clear();
        }
    }

    @Override
    public synchronized void registerListener(Plugin plugin, Object listener) {
        Objects.requireNonNull(plugin);
        Objects.requireNonNull(listener);
        if (this.store.containsKey(plugin)) {
            this.store.get(plugin).add(listener);
            this.builder.removeEventListeners(new Object[]{listener});
            if (this.jda != null) {
                this.jda.addEventListener(new Object[]{listener});
            }
        } else {
            throw new IllegalArgumentException("Provided plugin is not registered!");
        }
    }

    public synchronized void setJDA(JDA jda) {
        this.jda = jda;
    }
}

