/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.command;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.foxgenesis.config.fields.JSONObjectAdv;
import net.foxgenesis.watame.WatameBot;
import net.foxgenesis.watame.property.IGuildPropertyMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCommand
extends ListenerAdapter {
    public static final List<Command.Choice> options = Collections.unmodifiableList(Stream.of(OptionType.values()).filter(type -> type != OptionType.UNKNOWN && type != OptionType.SUB_COMMAND && type != OptionType.SUB_COMMAND_GROUP).map(word -> new Command.Choice(word.name().toLowerCase(), word.name())).collect(Collectors.toList()));
    private static final Logger logger = LoggerFactory.getLogger((String)"Configuration Command");

    public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
        if (event.isFromGuild()) {
            User user = event.getUser();
            switch (event.getCommandPath()) {
                case "config-get": {
                    event.deferReply(true).queue();
                    InteractionHook hook = event.getHook();
                    String key = (String)event.getOption("key", OptionMapping::getAsString);
                    logger.info("{}[{}] Checked configuration for {}", new Object[]{user.getName(), user.getId(), key});
                    hook.editOriginal("Value: " + ConfigCommand.getConfig(event.getGuild()).optString(key, "null/using default")).queue();
                    break;
                }
                case "config-set": {
                    event.deferReply(true).queue();
                    InteractionHook hook = event.getHook();
                    OptionType type = (OptionType)event.getOption("type", t -> OptionType.valueOf((String)t.getAsString().toUpperCase()));
                    if (type != null) {
                        String value = (String)event.getOption(type.name().toLowerCase(), null, OptionMapping::getAsString);
                        String key = (String)event.getOption("key", OptionMapping::getAsString);
                        logger.debug("Config-set t:{} k:{} v:{} [{}]", new Object[]{type, key, value, event.getOptions()});
                        ConfigCommand.updateConfig(hook, event.getGuild(), user, key, value);
                        break;
                    }
                    hook.editOriginal("Type is not valid!").queue();
                }
            }
        }
    }

    private static void updateConfig(@Nonnull InteractionHook hook, Guild guild, @Nonnull User user, String key, @Nullable String value) {
        JSONObjectAdv config = ConfigCommand.getConfig(guild);
        if (value == null) {
            config.remove(key);
            logger.info("{}[{}] Removed {} from the configuration", new Object[]{user.getName(), user.getId(), key});
            hook.editOriginal("Deleted " + key).queue();
        } else {
            config.put(key, value);
            logger.info("{}[{}] Put {} -> {} into the configuration", new Object[]{user.getName(), user.getId(), key, value});
            hook.editOriginal("Put " + value + " in " + key).queue();
        }
        TextChannel channel = WatameBot.getInstance().getGuildLoggingChannel().get(guild, IGuildPropertyMapping::getAsTextChannel);
        if (channel != null) {
            ((MessageCreateAction)channel.sendMessageEmbeds(new EmbedBuilder().setColor(Color.orange).setTitle("Configuration Change").addField("User", user.getAsMention(), true).addField("Key", key, true).addField("Value", value != null ? value : "N/A", true).addField("Type", value == null ? "Remove" : "Update", false).build(), new MessageEmbed[0]).addCheck(() -> ((TextChannel)channel).canTalk())).queue();
        }
    }

    private static JSONObjectAdv getConfig(Guild guild) {
        return WatameBot.getInstance().getDataForGuild(guild).getConfig();
    }
}

