/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.events.guild.GuildLeaveEvent;
import net.dv8tion.jda.api.events.guild.GuildReadyEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.ChunkingFilter;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import net.dv8tion.jda.internal.utils.IOUtil;
import net.foxgenesis.database.DatabaseManager;
import net.foxgenesis.database.IDatabaseManager;
import net.foxgenesis.database.providers.MySQLConnectionProvider;
import net.foxgenesis.property.IPropertyField;
import net.foxgenesis.property.IPropertyProvider;
import net.foxgenesis.util.ProgramArguments;
import net.foxgenesis.util.ResourceUtils;
import net.foxgenesis.watame.Context;
import net.foxgenesis.watame.ExitCode;
import net.foxgenesis.watame.Main;
import net.foxgenesis.watame.ProtectedJDABuilder;
import net.foxgenesis.watame.plugin.Plugin;
import net.foxgenesis.watame.plugin.PluginHandler;
import net.foxgenesis.watame.property.IGuildPropertyMapping;
import net.foxgenesis.watame.sql.IGuildData;
import net.foxgenesis.watame.sql.WatameBotDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class WatameBot {
    public static final Logger logger = LoggerFactory.getLogger(WatameBot.class);
    private static WatameBot instance;
    private static boolean toInit;
    private JDABuilder builder;
    private JDA discord;
    private final DatabaseManager manager;
    private final WatameBotDatabase database;
    private IPropertyField<String, Guild, IGuildPropertyMapping> logChannel;
    private State state = State.CONSTRUCTING;
    private final PluginHandler<Plugin> pluginHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WatameBot getInstance() {
        if (!toInit) return instance;
        Class<WatameBot> clazz = WatameBot.class;
        synchronized (WatameBot.class) {
            if (!toInit) return instance;
            ProgramArguments params = Main.getProgramArguments();
            if (!params.hasParameter("token")) {
                ExitCode.NO_TOKEN.programExit("No token file specified");
            }
            String token = Objects.requireNonNull(WatameBot.readToken(params.getParameter("token")));
            try {
                logger.debug("Creating WatameBot instance");
                instance = new WatameBot(token);
                toInit = false;
            }
            catch (SQLException e) {
                ExitCode.DATABASE_NOT_CONNECTED.programExit(e);
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            return instance;
        }
    }

    private static String readToken(String filepath) {
        String string;
        logger.debug("Getting token from file");
        BufferedReader br = new BufferedReader(new FileReader(filepath));
        try {
            string = br.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                ExitCode.INVALID_TOKEN.programExit(ex);
                return null;
            }
        }
        br.close();
        return string;
    }

    private WatameBot(@Nonnull String token) throws SQLException {
        this.updateState();
        logger.debug("Adding shutdown hook");
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown, "WatameBot Shutdown Thread"));
        this.manager = new DatabaseManager("WatameBot Database Manager");
        this.database = new WatameBotDatabase();
        this.logChannel = this.database.getProperty("log-channel");
        this.builder = this.createJDA(token);
        this.pluginHandler = new PluginHandler<Plugin>(new Context(this), this.getClass().getModule().getLayer(), Plugin.class);
    }

    void start() {
        this.pluginHandler.loadPlugins();
        this.state = State.PRE_INIT;
        logger.trace("STATE = " + this.state);
        this.updateState();
        this.preInit();
        this.state = State.INIT;
        logger.trace("STATE = " + this.state);
        this.updateState();
        this.init();
        this.state = State.POST_INIT;
        logger.trace("STATE = " + this.state);
        this.updateState();
        this.postInit();
        this.state = State.RUNNING;
        logger.trace("STATE = " + this.state);
        this.updateState();
        this.ready();
    }

    private void shutdown() {
        this.state = State.SHUTDOWN;
        this.updateState();
        logger.info("Shutting down...");
        IOUtil.silentClose(this.pluginHandler);
        if (this.discord != null) {
            logger.info("Shutting down JDA...");
            this.discord.shutdown();
        }
        try {
            logger.info("Closing database connection");
            if (this.database != null) {
                this.database.close();
            }
        }
        catch (Exception e) {
            logger.error("Error while closing database connection!", (Throwable)e);
        }
        if (!ForkJoinPool.commonPool().awaitQuiescence(1L, TimeUnit.MINUTES)) {
            logger.warn("Timed out waiting for common pool shutdown. Continuing shutdown...");
        }
        logger.info("Exiting...");
    }

    private void preInit() {
        CompletableFuture<Void> pluginPreInit = this.pluginHandler.preInit();
        try {
            logger.debug("Adding database to database manager");
            this.manager.register(this.pluginHandler.getPlugin("integrated"), this.database);
        }
        catch (IOException e) {
            ExitCode.DATABASE_SETUP_ERROR.programExit(e);
        }
        catch (IllegalArgumentException e) {
            ExitCode.DATABASE_INVALID_SETUP_FILE.programExit(e);
        }
        logger.trace("Waiting for plugin pre-initialization");
        pluginPreInit.join();
    }

    private void init() {
        ProtectedJDABuilder pBuilder = new ProtectedJDABuilder(this.builder);
        CompletableFuture<Void> pluginInit = this.pluginHandler.init(pBuilder);
        try {
            logger.info("Starting database pool");
            this.manager.start(new MySQLConnectionProvider(ResourceUtils.getProperties(Path.of("config", "database.properties"), new ResourceUtils.ModuleResource("watamebot", "defaults/database.properties")))).join();
        }
        catch (IOException e) {
            ExitCode.DATABASE_SETUP_ERROR.programExit(e);
        }
        logger.trace("Waiting for plugin initialization");
        pluginInit.join();
    }

    private void postInit() {
        logger.trace("Building discord connection");
        this.discord = this.buildJDA();
        CompletableFuture<Void> pluginPostInit = this.pluginHandler.postInit(this);
        this.pluginHandler.updateCommands(this.discord.updateCommands()).queue();
        logger.trace("Waiting for plugin post-initialization");
        pluginPostInit.join();
        if (this.discord.getStatus() != JDA.Status.CONNECTED) {
            try {
                logger.info("Waiting for JDA to be ready...");
                this.discord.awaitReady();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.info("Connected to discord!");
        this.builder = null;
    }

    private void ready() {
        this.pluginHandler.onReady(this);
        logger.debug("Setting presence to ready");
        this.discord.getPresence().setPresence(OnlineStatus.ONLINE, Activity.playing((String)"WatameBot 2"));
    }

    private JDABuilder createJDA(String token) {
        Objects.requireNonNull(token, "Login token must not be null");
        logger.debug("Creating JDA");
        JDABuilder builder = JDABuilder.create((String)token, (GatewayIntent)GatewayIntent.GUILD_MEMBERS, (GatewayIntent[])new GatewayIntent[]{GatewayIntent.GUILD_BANS, GatewayIntent.GUILD_MESSAGES, GatewayIntent.MESSAGE_CONTENT}).disableCache(CacheFlag.ACTIVITY, new CacheFlag[]{CacheFlag.VOICE_STATE, CacheFlag.EMOJI, CacheFlag.STICKER, CacheFlag.CLIENT_STATUS, CacheFlag.ONLINE_STATUS}).setChunkingFilter(ChunkingFilter.NONE).setAutoReconnect(true).setActivity(Activity.playing((String)"Initializing...")).setStatus(OnlineStatus.DO_NOT_DISTURB);
        builder.addEventListeners(new Object[]{new ListenerAdapter(){

            public void onGuildReady(@Nonnull GuildReadyEvent e) {
                WatameBot.this.database.addGuild(e.getGuild());
            }

            public void onGuildLeave(@Nonnull GuildLeaveEvent e) {
                WatameBot.this.database.removeGuild(e.getGuild());
            }
        }});
        return builder;
    }

    private JDA buildJDA() {
        JDA discordTmp = null;
        boolean built = false;
        do {
            try {
                logger.info("Attempting to login to discord");
                discordTmp = this.builder.build();
                built = true;
            }
            catch (LoginException ex) {
                logger.warn("Failed to connect: " + ex.getLocalizedMessage() + " retrying...", (Throwable)ex);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (!built);
        if (discordTmp == null) {
            ExitCode.JDA_BUILD_FAIL.programExit("Failed to build JDA");
            return null;
        }
        return discordTmp;
    }

    public boolean isConnectedToDiscord() {
        return this.discord != null && this.discord.getStatus() == JDA.Status.CONNECTED;
    }

    public IDatabaseManager getDatabaseManager() {
        return this.manager;
    }

    @Deprecated(forRemoval=true)
    public IGuildData getDataForGuild(Guild guild) {
        return this.database.getDataForGuild(guild);
    }

    public IPropertyProvider<String, Guild, IGuildPropertyMapping> getPropertyProvider() {
        return this.database;
    }

    public IPropertyField<String, Guild, IGuildPropertyMapping> getGuildLoggingChannel() {
        return this.logChannel;
    }

    public JDA getJDA() {
        return this.discord;
    }

    public State getState() {
        return this.state;
    }

    private void updateState() {
        MDC.put((String)"watame.status", (String)this.state.name());
    }

    static {
        toInit = true;
    }

    public static enum State {
        CONSTRUCTING,
        PRE_INIT,
        INIT,
        POST_INIT,
        RUNNING,
        SHUTDOWN;

        public final Marker marker = MarkerFactory.getMarker((String)this.name());
    }
}

