/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame;

import org.slf4j.LoggerFactory;

public enum ExitCode {
    INSTANCE_ALREADY_RUNNING(1),
    SETUP_ERROR(2),
    RESOURCE_IO_ERROR(5),
    NO_TOKEN(12),
    INVALID_TOKEN(13),
    JDA_BUILD_FAIL(20),
    DATABASE_NOT_CONNECTED(30),
    DATABASE_INVALID_SETUP_FILE(31),
    DATABASE_SETUP_ERROR(32),
    DATABASE_ACCESS_ERROR(33),
    DATABASE_STATEMENT_MISSING(34),
    DATABASE_STATEMENT_ERROR(35);

    private final int statusCode;

    private ExitCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public Integer getCode() {
        return this.statusCode;
    }

    public void programExit(String exitMessage, Throwable thrown) {
        LoggerFactory.getLogger((String)"global").error(exitMessage == null ? this.name() : exitMessage, thrown);
        this.programExit();
    }

    public void programExit(Throwable thrown) {
        this.programExit(null, thrown);
    }

    public void programExit(String exitMessage) {
        this.programExit(exitMessage, null);
    }

    public void programExit() {
        System.exit(this.getCode());
    }
}

