/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResourceUtils.class);

    public static List<String> linesFromResource(URL path) throws IOException {
        logger.trace("Attempting to read resource: " + path);
        ArrayList<String> list = new ArrayList<String>();
        try (InputStreamReader isr = new InputStreamReader(path.openStream());){
            ArrayList<String> arrayList;
            try (BufferedReader reader = new BufferedReader(isr);){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    list.add(line);
                }
                arrayList = list;
            }
            return arrayList;
        }
    }

    public static Properties getProperties(URL path) throws IOException {
        logger.trace("Attempting to read resource: " + path);
        Properties properties = new Properties();
        properties.load(path.openStream());
        return properties;
    }

    public static Properties getProperties(Path path, ModuleResource defaults) throws IOException {
        if (defaults != null && Files.notExists(path, LinkOption.NOFOLLOW_LINKS)) {
            defaults.writeToFile(path);
            return ResourceUtils.getProperties(path, defaults);
        }
        Properties properties = new Properties();
        properties.load(Files.newInputStream(path, StandardOpenOption.READ));
        return properties;
    }

    public static PropertiesConfiguration loadConfig(ModuleResource defaults, Path dir, String output) throws IOException, ConfigurationException {
        if (Files.notExists(dir, LinkOption.NOFOLLOW_LINKS)) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        Path outputPath = dir.resolve(output);
        if (Files.notExists(outputPath, LinkOption.NOFOLLOW_LINKS)) {
            defaults.writeToFile(outputPath);
        } else {
            if (Files.isDirectory(outputPath, LinkOption.NOFOLLOW_LINKS)) {
                throw new IllegalArgumentException(outputPath.toString() + " is not a regular file!");
            }
            if (!Files.isReadable(outputPath)) {
                throw new SecurityException("Unable to read " + outputPath.toString() + ". Missing permissions!");
            }
        }
        PropertiesBuilderParameters propParams = new Parameters().properties();
        propParams.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        propParams.setBasePath(dir.toString());
        propParams.setPath(outputPath.toString());
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class);
        builder.configure(new BuilderParameters[]{propParams});
        return (PropertiesConfiguration)builder.getConfiguration();
    }

    public static String toString(@Nonnull InputStream input) throws IOException {
        Objects.requireNonNull(input, "InputStream must not be null!");
        return new String(input.readAllBytes());
    }

    public static String[] toSplitString(@Nonnull InputStream input) throws IOException {
        return ResourceUtils.toString(input).split("(\\r\\n|\\r|\\n)");
    }

    public record ModuleResource(Module module, String resourcePath) {
        public ModuleResource(String moduleName, String resourcePath) {
            this(ModuleLayer.boot().findModule(moduleName).orElseThrow(() -> new NoSuchElementException("No module found '" + moduleName + "'")), resourcePath);
        }

        public InputStream openStream() throws IOException {
            logger.trace("Attempting to read resource: " + this.resourcePath);
            return this.module.getResourceAsStream(this.resourcePath);
        }

        public void writeToFile(Path path) throws IOException {
            Files.copy(this.openStream(), path, new CopyOption[0]);
        }

        public String readToString() throws IOException {
            return ResourceUtils.toString(this.openStream());
        }

        public String[] readAllLines() throws IOException {
            return ResourceUtils.toSplitString(this.openStream());
        }

        public Properties asProperties() throws IOException {
            Properties properties = new Properties();
            properties.load(this.openStream());
            return properties;
        }
    }
}

