/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.property.database;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.DatabaseConfiguration;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.fluent.DatabaseBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;

public class ConfigurationDatabase {
    private final BasicConfigurationBuilder<DatabaseConfiguration> builder = new BasicConfigurationBuilder(DatabaseConfiguration.class);
    private final DataSource source;
    private final String table;
    private final String configNameColumn;
    private final String keyColumn;
    private final String valueColumn;

    public ConfigurationDatabase(@Nonnull DataSource dataSource, @Nonnull String table, @Nonnull String configNameColumn, @Nonnull String keyColumn, @Nonnull String valueColumn) {
        this.source = Objects.requireNonNull(dataSource);
        this.table = Objects.requireNonNull(table);
        this.configNameColumn = Objects.requireNonNull(configNameColumn);
        this.keyColumn = Objects.requireNonNull(keyColumn);
        this.valueColumn = Objects.requireNonNull(valueColumn);
    }

    public Configuration getConfiguration(@Nonnull String configurationName) throws ConfigurationException {
        this.builder.resetParameters();
        this.builder.configure(new BuilderParameters[]{this.newConfig(Objects.requireNonNull(configurationName))});
        return (Configuration)this.builder.getConfiguration();
    }

    private DatabaseBuilderParameters newConfig(String name) {
        return (DatabaseBuilderParameters)((DatabaseBuilderParameters)((DatabaseBuilderParameters)((DatabaseBuilderParameters)((DatabaseBuilderParameters)((DatabaseBuilderParameters)new Parameters().database().setDataSource(this.source)).setTable(this.table)).setKeyColumn(this.keyColumn)).setValueColumn(this.valueColumn)).setConfigurationNameColumn(this.configNameColumn)).setConfigurationName(name);
    }
}

