/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.executor;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;

public class PrefixedThreadFactory
implements ThreadFactory {
    private final AtomicLong count = new AtomicLong(1L);
    @Nonnull
    private final String prefix;
    private final boolean daemon;

    public PrefixedThreadFactory(@Nonnull String prefix) {
        this(prefix, true);
    }

    public PrefixedThreadFactory(@Nonnull String prefix, boolean daemon) {
        this.prefix = Objects.requireNonNull(prefix);
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r, this.prefix + "-Worker " + this.count.getAndIncrement());
        thread.setDaemon(this.daemon);
        return thread;
    }

    @Nonnull
    public String getPrefix() {
        return this.prefix;
    }

    public boolean isDaemon() {
        return this.daemon;
    }
}

