/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.database;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.foxgenesis.database.AConnectionProvider;
import net.foxgenesis.database.AbstractDatabase;
import net.foxgenesis.database.IDatabaseManager;
import net.foxgenesis.util.CompletableFutureUtils;
import net.foxgenesis.watame.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseManager
implements IDatabaseManager {
    @Nonnull
    protected final Logger logger;
    private final HashMap<Plugin, Set<AbstractDatabase>> databases = new HashMap();
    @Nonnull
    private final String name;
    @Nullable
    private AConnectionProvider provider;
    private boolean ready = false;

    public DatabaseManager(@Nonnull String name) {
        this.name = Objects.requireNonNull(name);
        this.logger = LoggerFactory.getLogger((String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean register(@Nonnull Plugin plugin, @Nonnull AbstractDatabase database) throws IOException {
        Objects.requireNonNull(database);
        if (this.isDatabaseRegistered(database)) {
            throw new IllegalArgumentException("Database is already registered!");
        }
        this.logger.debug("Registering database {}", (Object)database.getName());
        boolean wasAdded = false;
        HashMap<Plugin, Set<AbstractDatabase>> hashMap = this.databases;
        synchronized (hashMap) {
            this.databases.putIfAbsent(plugin, new HashSet());
            wasAdded = this.databases.get(plugin).add(database);
        }
        if (wasAdded && this.ready && this.provider != null) {
            database.setup(this.provider);
            database.onReady();
        }
        return wasAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unload(Plugin owner) {
        if (!owner.needsDatabase) {
            return false;
        }
        if (this.databases.containsKey(owner)) {
            HashMap<Plugin, Set<AbstractDatabase>> hashMap = this.databases;
            synchronized (hashMap) {
                if (this.databases.containsKey(owner)) {
                    this.logger.info("Unloading databases from {}", (Object)owner.friendlyName);
                    Set<AbstractDatabase> databases = this.databases.remove(owner);
                    for (AbstractDatabase database : databases) {
                        database.unload();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isDatabaseRegistered(AbstractDatabase database) {
        return this.databases.values().stream().anyMatch(set -> set.contains(database));
    }

    public CompletableFuture<Void> start(@Nonnull AConnectionProvider provider) throws ConnectException {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> {
            this.provider = Objects.requireNonNull(provider);
            this.logger.info("Starting {} using provider {}", (Object)this.name, (Object)provider.getName());
            this.logger.debug("Collecting database setup lines");
            List<String> setupLines = this.collectDatabaseSetupLines();
            HashMap<Plugin, Set<AbstractDatabase>> hashMap = this.databases;
            synchronized (hashMap) {
                provider.openAutoClosedConnection(connection -> {
                    try (Statement statement = connection.createStatement();){
                        for (String line : setupLines) {
                            try {
                                statement.execute(line);
                            }
                            catch (SQLException e) {
                                this.logger.error("Error executing database setup line [" + line + "]", (Throwable)e);
                            }
                        }
                    }
                    return null;
                }, error -> this.logger.error("Error while setting up database tables", error));
            }
        }).thenCompose(v -> {
            HashMap<Plugin, Set<AbstractDatabase>> hashMap = this.databases;
            synchronized (hashMap) {
                return CompletableFutureUtils.allOf(this.databases.values().stream().flatMap(Collection::stream).map(database -> CompletableFuture.runAsync(() -> {
                    try {
                        database.setup(provider);
                    }
                    catch (IOException e) {
                        throw new CompletionException(e);
                    }
                }).exceptionally(e -> {
                    this.logger.error("Error while setting up " + database.getName(), e);
                    return null;
                })));
            }
        })).thenRun(() -> {
            this.ready = true;
        })).thenCompose(v -> {
            HashMap<Plugin, Set<AbstractDatabase>> hashMap = this.databases;
            synchronized (hashMap) {
                return CompletableFutureUtils.allOf(this.databases.values().stream().flatMap(Collection::stream).map(database -> CompletableFuture.runAsync(() -> database.onReady()).exceptionally(e -> {
                    this.logger.error("Error while setting up " + database.getName(), e);
                    return null;
                })));
            }
        });
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> collectDatabaseSetupLines() {
        ArrayList<String> lines = new ArrayList<String>();
        HashMap<Plugin, Set<AbstractDatabase>> hashMap = this.databases;
        synchronized (hashMap) {
            for (Set<AbstractDatabase> databases : this.databases.values()) {
                for (AbstractDatabase database : databases) {
                    try {
                        for (String line : database.getSetupLines()) {
                            lines.add(line);
                        }
                    }
                    catch (IOException e) {
                        this.logger.error("Error while reading setup lines from " + database.getName(), (Throwable)e);
                    }
                }
            }
        }
        return lines;
    }
}

