/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.database;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.internal.utils.IOUtil;
import net.foxgenesis.config.KVPFile;
import net.foxgenesis.database.AConnectionProvider;
import net.foxgenesis.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabase
implements AutoCloseable {
    @Nonnull
    private final HashMap<String, String> statements = new HashMap();
    @Nonnull
    private final ResourceUtils.ModuleResource operationsFile;
    @Nonnull
    private final ResourceUtils.ModuleResource setupFile;
    @Nonnull
    private final String name;
    @Nonnull
    protected final Logger logger;
    @Nullable
    private AConnectionProvider provider;

    public AbstractDatabase(@Nonnull String name, @Nonnull ResourceUtils.ModuleResource operationsFile, @Nonnull ResourceUtils.ModuleResource setupFile) {
        this.name = Objects.requireNonNull(name);
        this.operationsFile = Objects.requireNonNull(operationsFile);
        this.setupFile = Objects.requireNonNull(setupFile);
        this.logger = LoggerFactory.getLogger((String)name);
    }

    final synchronized void setup(@Nonnull AConnectionProvider provider) throws IOException {
        if (this.provider != null) {
            throw new UnsupportedOperationException("Database is already setup!");
        }
        Objects.requireNonNull(provider);
        this.logger.debug("Setting up {} with provider {}", (Object)this.name, (Object)provider.getName());
        new KVPFile(this.operationsFile).forEach((id, raw) -> {
            if (!this.hasStatementID((String)id)) {
                this.registerStatement((String)id, (String)raw);
            } else {
                this.logger.error("Statement id {} is already registered!", id);
            }
        });
        this.provider = provider;
        this.onReady();
    }

    final synchronized void unload() {
        IOUtil.silentClose((AutoCloseable)this);
        this.provider = null;
    }

    protected abstract void onReady();

    protected Connection openConnection() throws SQLException {
        if (!this.isReady()) {
            throw new UnsupportedOperationException("Database has not been setup yet!");
        }
        if (this.provider != null) {
            return this.provider.openConnection();
        }
        throw new UnsupportedOperationException("Database has not been setup yet!");
    }

    protected <U> CompletableFuture<U> prepareStatementAsync(String id, Function<PreparedStatement, U> func) {
        if (!this.hasStatementID(id)) {
            throw new NoSuchElementException("No statement exists with id " + id);
        }
        if (!this.isReady()) {
            throw new UnsupportedOperationException("Database has not been setup yet!");
        }
        if (this.provider != null) {
            CompletableFuture<PreparedStatement> future = this.provider.asyncConnection(conn -> {
                try {
                    return conn.prepareStatement(this.getRawStatement(id));
                }
                catch (SQLException e) {
                    throw new CompletionException(e);
                }
            });
            CompletableFuture<PreparedStatement> copy = future.copy();
            return ((CompletableFuture)future.thenApplyAsync((Function)func)).whenCompleteAsync((result, error) -> copy.thenAccept(IOUtil::silentClose));
        }
        return CompletableFuture.failedFuture(new UnsupportedOperationException("Database has not been setup yet!"));
    }

    protected <U> CompletableFuture<U> prepareCallableAsync(String id, Function<CallableStatement, U> func) {
        if (!this.hasStatementID(id)) {
            throw new NoSuchElementException("No statement exists with id " + id);
        }
        if (!this.isReady()) {
            throw new UnsupportedOperationException("Database has not been setup yet!");
        }
        if (this.provider != null) {
            CompletableFuture<CallableStatement> future = this.provider.asyncConnection(conn -> {
                try {
                    return conn.prepareCall(this.getRawStatement(id));
                }
                catch (SQLException e) {
                    throw new CompletionException(e);
                }
            });
            CompletableFuture<CallableStatement> copy = future.copy();
            return ((CompletableFuture)future.thenApplyAsync((Function)func)).whenCompleteAsync((result, error) -> copy.thenAccept(IOUtil::silentClose));
        }
        return CompletableFuture.failedFuture(new UnsupportedOperationException("Database has not been setup yet!"));
    }

    protected void prepareStatement(String id, SQLConsumer<PreparedStatement> func, Consumer<Throwable> error) {
        if (!this.hasStatementID(id)) {
            throw new NoSuchElementException("No statement exists with id " + id);
        }
        if (!this.isReady()) {
            throw new UnsupportedOperationException("Database has not been setup yet!");
        }
        if (this.provider == null) {
            throw new UnsupportedOperationException("Database has not been setup yet!");
        }
        this.provider.openAutoClosedConnection(conn -> {
            try (PreparedStatement statement = conn.prepareStatement(this.getRawStatement(id));){
                func.accept(statement);
                Object var5_5 = null;
                return var5_5;
            }
        }, error);
    }

    protected void prepareCallable(String id, SQLConsumer<CallableStatement> func, Consumer<Throwable> error) {
        if (!this.hasStatementID(id)) {
            throw new NoSuchElementException("No statement exists with id " + id);
        }
        if (!this.isReady()) {
            throw new UnsupportedOperationException("Database has not been setup yet!");
        }
        if (this.provider == null) {
            throw new UnsupportedOperationException("Database has not been setup yet!");
        }
        this.provider.openAutoClosedConnection(conn -> {
            try (CallableStatement statement = conn.prepareCall(this.getRawStatement(id));){
                func.accept(statement);
                Object var5_5 = null;
                return var5_5;
            }
        }, error);
    }

    protected <U> U mapStatement(String id, SQLFunction<PreparedStatement, U> func, Consumer<Throwable> error) {
        if (!this.hasStatementID(id)) {
            throw new NoSuchElementException("No statement exists with id " + id);
        }
        if (!this.isReady()) {
            throw new UnsupportedOperationException("Database has not been setup yet!");
        }
        if (this.provider != null) {
            return (U)this.provider.openAutoClosedConnection(conn -> {
                try (PreparedStatement statement = conn.prepareStatement(this.getRawStatement(id));){
                    Object v = func.apply(statement);
                    return v;
                }
            }, error);
        }
        throw new UnsupportedOperationException("Database has not been setup yet!");
    }

    protected <U> U mapCallable(String id, SQLFunction<CallableStatement, U> func, Consumer<Throwable> error) {
        if (!this.hasStatementID(id)) {
            throw new NoSuchElementException("No statement exists with id " + id);
        }
        if (!this.isReady()) {
            throw new UnsupportedOperationException("Database has not been setup yet!");
        }
        if (this.provider != null) {
            return (U)this.provider.openAutoClosedConnection(conn -> {
                try (CallableStatement statement = conn.prepareCall(this.getRawStatement(id));){
                    Object v = func.apply(statement);
                    return v;
                }
            }, error);
        }
        throw new UnsupportedOperationException("Database has not been setup yet!");
    }

    private void registerStatement(@Nonnull String id, @Nonnull String raw) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(raw);
        if (this.statements.containsKey(id)) {
            throw new IllegalArgumentException("id [" + id + "] is already registered!");
        }
        this.logger.debug("Adding statement with id {} [{}]", (Object)id, (Object)raw);
        this.statements.put(id, raw);
    }

    protected final boolean hasStatementID(String id) {
        return this.statements.containsKey(id);
    }

    protected final String getRawStatement(String id) {
        if (!this.hasStatementID(id)) {
            throw new NoSuchElementException("No statement exists with id " + id);
        }
        return this.statements.get(id);
    }

    final String[] getSetupLines() throws IOException {
        return this.setupFile.readAllLines();
    }

    @Nonnull
    public final String getName() {
        return this.name;
    }

    public boolean isReady() {
        return this.provider != null;
    }

    @FunctionalInterface
    public static interface SQLConsumer<U> {
        public void accept(U var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface SQLFunction<U, V> {
        public V apply(U var1) throws SQLException;
    }
}

