/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.foxgenesis.util.ResourceUtils;

public class KVPFile {
    private static final Predicate<String> ignoreLines = line -> line.matches("^(.+?)=(.*?)$");
    private final HashMap<String, String> config = new HashMap();

    public KVPFile() {
    }

    public KVPFile(@Nonnull File file) throws IOException {
        this(file.toURI().toURL());
    }

    public KVPFile(@Nonnull URL url) throws IOException {
        Objects.requireNonNull(url);
        this.parse(url);
    }

    public KVPFile(@Nonnull InputStream input) throws IOException {
        Objects.requireNonNull(input);
        this.parse(input);
    }

    public KVPFile(@Nonnull ResourceUtils.ModuleResource resource) throws IOException {
        Objects.requireNonNull(resource);
        this.parse(resource);
    }

    public void forEach(BiConsumer<? super String, ? super String> action) {
        this.config.forEach(action);
    }

    @Nullable
    public String get(String key) {
        return this.config.get(key);
    }

    @Nullable
    public String getOrDefault(String key, String defaultValue) {
        return this.config.getOrDefault(key, defaultValue);
    }

    public boolean containsKey(String key) {
        return this.config.containsKey(key);
    }

    public void clear() {
        this.config.clear();
    }

    public boolean isEmpty() {
        return this.config.isEmpty();
    }

    public void parse(@Nonnull URL resourceURL) throws IOException {
        this.parse(ResourceUtils.linesFromResource(Objects.requireNonNull(resourceURL, "Resource url must not be null!")));
    }

    public void parse(@Nonnull InputStream input) throws IOException {
        this.parse(List.of(ResourceUtils.toSplitString(Objects.requireNonNull(input, "InputStream must not be null!"))));
    }

    public void parse(@Nonnull ResourceUtils.ModuleResource resource) throws IOException {
        this.parse(resource.openStream());
    }

    private void parse(List<String> input) {
        if (input == null) {
            return;
        }
        Map<String, String> tempMap = input.stream().filter(ignoreLines).map(line -> line.split("=", 2)).filter(split -> ((String[])split).length == 2).collect(Collectors.toMap(split -> split[0].trim(), split -> split[1].trim()));
        this.config.putAll(tempMap);
    }
}

