/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.sql;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.foxgenesis.config.KVPFile;
import net.foxgenesis.util.ResourceUtils;
import net.foxgenesis.watame.ExitCode;
import net.foxgenesis.watame.sql.DatabaseProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractDatabase
implements AutoCloseable {
    @Nonnull
    protected final Logger logger;
    @Nullable
    private final URL databaseSetupFile;
    @Nonnull
    private final URL databaseOperationsFile;
    @Nonnull
    private final List<Runnable> onClose = new ArrayList<Runnable>();
    @Nonnull
    protected DataSource source;
    @Nonnull
    private final ConcurrentHashMap<String, String> registeredStatements = new ConcurrentHashMap();

    public AbstractDatabase(@Nonnull DatabaseProperties properties) {
        Objects.requireNonNull(properties);
        this.logger = LoggerFactory.getLogger((String)properties.name());
        this.source = Objects.requireNonNull(properties.source());
        this.databaseSetupFile = Objects.requireNonNull(properties.setupFile());
        this.databaseOperationsFile = Objects.requireNonNull(properties.operationsFile());
    }

    public synchronized void setup() throws SQLException, UnsupportedOperationException, IOException {
        if (Objects.nonNull(this.databaseSetupFile)) {
            this.setupDatabase(this.databaseSetupFile);
        }
        if (Objects.nonNull(this.databaseOperationsFile)) {
            this.initalizeOperations(this.databaseOperationsFile);
        }
    }

    private void setupDatabase(@Nonnull URL url) throws IOException, UnsupportedOperationException {
        Objects.requireNonNull(url);
        this.logger.trace("Reading lines from SQL file");
        List<String> lines = ResourceUtils.linesFromResource(url);
        try (Connection conn = this.source.getConnection();){
            for (String line : lines) {
                if (line.startsWith("--")) continue;
                Statement statement = conn.createStatement();
                try {
                    this.logger.trace("Executing SQL statement: " + line);
                    statement.execute(line);
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            ExitCode.DATABASE_SETUP_ERROR.programExit(e);
            return;
        }
    }

    private void initalizeOperations(@Nonnull URL url) throws IOException {
        KVPFile kvp = new KVPFile(url);
        kvp.forEach((key, value) -> {
            if (this.registeredStatements.containsKey(key)) {
                this.logger.error("Statement '{}' already exists! Skipping...", key);
            } else {
                try {
                    this.registerStatement((String)key, (String)value);
                }
                catch (SQLException e) {
                    ExitCode.DATABASE_STATEMENT_ERROR.programExit(e);
                    return;
                }
            }
        });
    }

    private void registerStatement(String id, @Nonnull String statement) throws SQLException {
        Objects.requireNonNull(statement);
        if (this.registeredStatements.containsKey(id)) {
            throw new IllegalArgumentException("Statement '" + id + "' already exists!");
        }
        this.logger.trace("Creating PreparedStatement {} : {}", (Object)id, (Object)statement);
        this.registeredStatements.put(id, statement);
    }

    @CheckForNull
    protected String getRawStatement(String id) {
        return this.registeredStatements.get(id);
    }

    @Nullable
    protected String assertRawStatement(String id) {
        String statement = this.getRawStatement(id);
        if (statement != null) {
            return statement;
        }
        ExitCode.DATABASE_STATEMENT_MISSING.programExit(String.format("Statement with id '%s' is not registered!", id));
        return null;
    }

    protected <R> R mapStatement(@Nonnull String id, @Nonnull StatementFunction<R> function) {
        return this.mapStatement(id, function, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected <R> R mapStatement(String id, @Nonnull StatementFunction<R> function, Consumer<SQLException> errorHandler) {
        String raw = this.assertRawStatement(id);
        try (Connection conn = this.source.getConnection();){
            R r;
            block16: {
                PreparedStatement statement = conn.prepareStatement(raw);
                try {
                    r = function.apply(statement);
                    if (statement == null) break block16;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return r;
        }
        catch (SQLException e) {
            if (errorHandler != null) {
                errorHandler.accept(e);
            } else {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected void callStatement(@Nonnull String id, @Nonnull StatementConsumer consumer) {
        this.callStatement(id, consumer, null);
    }

    protected void callStatement(@Nonnull String id, @Nonnull StatementConsumer consumer, Consumer<SQLException> errorHandler) {
        this.mapStatement(id, statement -> {
            consumer.accept(statement);
            return null;
        }, errorHandler);
    }

    private void createDatabaseFile(@Nonnull File file) {
        Objects.requireNonNull(file);
        File folder = file.getParentFile();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (file.exists()) {
            if (!file.isFile()) {
                throw new IllegalArgumentException("Selected file is a directory!");
            }
        } else {
            try {
                this.logger.info("Repo file does not exist! Creating...");
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addCloseHandler(Runnable onClose) {
        this.onClose.add(onClose);
    }

    public void removeCloseHandler(Runnable toRemove) {
        if (this.onClose.contains(toRemove)) {
            this.onClose.remove(toRemove);
        }
    }

    @Override
    public synchronized void close() throws Exception {
        this.onClose.forEach(Runnable::run);
    }

    public String toString() {
        return "AbstractDatabase [source=" + this.source + ", databaseSetupFile=" + this.databaseSetupFile + ", databaseOperationsFile=" + this.databaseOperationsFile + ", registeredStatements=" + this.registeredStatements + "]";
    }

    @FunctionalInterface
    protected static interface StatementFunction<R> {
        public R apply(PreparedStatement var1) throws SQLException;
    }

    @FunctionalInterface
    protected static interface StatementConsumer {
        public void accept(PreparedStatement var1) throws SQLException;
    }
}

