/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Objects;

public final class SingleInstanceUtil {
    private static PIDLock lock;

    public static void waitAndGetLock(int amt) {
        SingleInstanceUtil.waitAndGetLock(new File(".pid"), amt, 10000);
    }

    public static void waitAndGetLock(File file, int amt) {
        SingleInstanceUtil.waitAndGetLock(file, amt, 10000);
    }

    public static void waitAndGetLock(File file, int amt, int delay) {
        if (lock != null && lock.isValid()) {
            throw new UnsupportedOperationException("Single instance lock already obtained!");
        }
        PIDLock tempLock = new PIDLock(file);
        int tries = 0;
        while (true) {
            ++tries;
            try {
                tempLock.tryLock();
            }
            catch (IOException ex) {
                if (tries >= amt) {
                    throw new SingleInstanceLockException(file, amt);
                }
                System.err.println("Unable to obtain lock. Retrying again in 5 seconds.");
                ex.printStackTrace();
                try {
                    Thread.sleep(Math.abs(delay));
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        lock = tempLock;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                lock.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, "PIDLock release thread"));
    }

    private static class PIDLock
    implements AutoCloseable {
        private final File file;
        private FileChannel channel;

        public PIDLock(File file) {
            this.file = Objects.requireNonNull(file);
            this.ensureFile();
        }

        public void tryLock() throws IOException {
            FileOutputStream out = new FileOutputStream(this.file);
            FileChannel tempChannel = out.getChannel();
            tempChannel.lock();
            out.write(("" + ProcessHandle.current().pid()).getBytes());
            this.channel = tempChannel;
        }

        private void ensureFile() {
            if (!this.file.exists()) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.file.deleteOnExit();
        }

        public boolean isValid() {
            return this.channel != null && this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }

    public static class SingleInstanceLockException
    extends RuntimeException {
        private static final long serialVersionUID = -3575228601357312336L;
        private final File pidLocation;
        private final int retries;

        public SingleInstanceLockException(File file, int retries) {
            this.pidLocation = file;
            this.retries = retries;
        }

        @Override
        public String getMessage() {
            return String.format("Failed to obtain lock on PID file %s after %d retries.", this.pidLocation, this.retries);
        }
    }
}

