/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProgramArguments {
    private final List<String> argsList = new ArrayList<String>();
    private final HashMap<String, String> parameterList = new HashMap();
    private final List<String> flagList = new ArrayList<String>();

    public ProgramArguments() {
    }

    public ProgramArguments(String[] args) {
        this.parse(args);
    }

    public void parse(String[] args) {
        block7: for (int i = 0; i < args.length; ++i) {
            switch (args[i].charAt(0)) {
                case '-': {
                    if (args[i].length() < 2) {
                        throw new IllegalArgumentException("Not a valid argument: " + args[i]);
                    }
                    switch (args[i].charAt(1)) {
                        case '-': {
                            if (args[i].length() < 3) {
                                throw new IllegalArgumentException("Not a valid argument: " + args[i]);
                            }
                            this.flagList.add(args[i].substring(2));
                            continue block7;
                        }
                        case 'D': {
                            continue block7;
                        }
                    }
                    if (args.length - 1 == i) {
                        throw new IllegalArgumentException("Expected arg after: " + args[i]);
                    }
                    this.parameterList.put(args[i].substring(1), args[i + 1]);
                    ++i;
                    continue block7;
                }
                default: {
                    this.argsList.add(args[i]);
                }
            }
        }
    }

    public int argumentCount() {
        return this.argsList.size();
    }

    public int flagCount() {
        return this.flagList.size();
    }

    public int parameterCount() {
        return this.parameterList.size();
    }

    public boolean hasFlag(String key) {
        return this.flagList.contains(key);
    }

    public boolean hasParameter(String key) {
        return this.parameterList.containsKey(key);
    }

    public String getParameter(String key) {
        if (this.hasParameter(key)) {
            return this.parameterList.get(key);
        }
        throw new NullPointerException("Parameter list does not contain key \"" + key + "\"");
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameterList);
    }

    public List<String> getArguments() {
        return List.copyOf(this.argsList);
    }

    public void clear() {
        this.argsList.clear();
        this.parameterList.clear();
        this.flagList.clear();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ProgramArguments{flagList=");
        builder.append(Arrays.toString(this.flagList.toArray(new String[0])));
        builder.append(", parameterList=");
        builder.append(this.parameterList);
        builder.append(", argsList=");
        builder.append(Arrays.toString(this.argsList.toArray(new String[0])));
        builder.append('}');
        return builder.toString();
    }
}

