/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.util;

public final class MethodTimer {
    public static double run(Runnable r) {
        long n = System.nanoTime();
        r.run();
        return (double)(System.nanoTime() - n) / 1000000.0;
    }

    public static double run(Runnable r, int n) {
        long count = 0L;
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            System.out.printf("===== Run #%s =====\n", i + 1);
            sum += MethodTimer.run(r);
            ++count;
        }
        return sum / (double)count;
    }

    public static String runFormatMS(Runnable r) {
        return MethodTimer.runFormatMS(r, 2);
    }

    public static String runFormatMS(Runnable r, int decimals) {
        return String.format("%." + decimals + "f ms", MethodTimer.run(r));
    }

    public static String runFormatMS(Runnable r, int n, int decimals) {
        return String.format("%." + decimals + "f ms", MethodTimer.run(r, n));
    }
}

