/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.Channel;
import net.dv8tion.jda.api.entities.Guild;
import net.foxgenesis.config.fields.JSONObjectAdv;
import net.foxgenesis.watame.sql.DataManager;
import net.foxgenesis.watame.sql.IGuildData;

public class GuildData
implements IGuildData,
AutoCloseable {
    @Nonnull
    private final DataManager dataManager;
    @Nonnull
    private final Guild guild;
    private final ConcurrentHashMap<String, Object> temp = new ConcurrentHashMap();
    private JSONObjectAdv data;
    private boolean setup = false;

    GuildData(@Nonnull Guild guild, @Nonnull DataManager dataManager) {
        Objects.nonNull(dataManager);
        this.dataManager = dataManager;
        Objects.nonNull(guild);
        this.guild = guild;
    }

    @Override
    public Guild getGuild() {
        this.checkSetup();
        return this.guild;
    }

    @Override
    @Nullable
    public JSONObjectAdv getConfig() {
        this.checkSetup();
        return this.data;
    }

    @Override
    @CheckForNull
    public Channel getLogChannel() {
        this.checkSetup();
        return this.guild.getTextChannelById(this.data.optLong("guild.log_channel"));
    }

    @Override
    public ConcurrentHashMap<String, Object> getTempData() {
        this.checkSetup();
        return this.temp;
    }

    void setData(@Nonnull ResultSet result) throws SQLException {
        Objects.nonNull(result);
        String jsonString = result.getString("GuildProperties");
        DataManager.sqlLogger.debug(DataManager.SQL_MARKER, "SetData <- [{}] {}", (Object)this.guild.getName(), (Object)jsonString);
        if (jsonString == null) {
            DataManager.logger.warn("JSON STRING IS NULL FOR " + this.guild.getIdLong(), (Throwable)new NullPointerException("JSON STRING IS NULL FOR " + this.guild.getIdLong()));
            return;
        }
        this.data = new JSONObjectAdv(jsonString, this::pushJSONUpdate);
        this.setup = true;
    }

    private void pushJSONUpdate(@Nonnull String name, @Nullable Object data, boolean remove) {
        int result;
        block18: {
            Objects.nonNull(name);
            if (remove) {
                try (PreparedStatement removeStatement = this.dataManager.getAndAssertStatement("guild_json_remove");){
                    removeStatement.setString(1, "$." + name);
                    DataManager.sqlLogger.debug(DataManager.UPDATE_MARKER, "PushUpdate -> " + removeStatement);
                    result = removeStatement.executeUpdate();
                    break block18;
                }
                catch (SQLException e) {
                    DataManager.logger.error(DataManager.UPDATE_MARKER, "Error while removing guild json data", (Throwable)e);
                    return;
                }
            }
            if (data == null) {
                throw new IllegalArgumentException("Data must not be null if 'remove' is 'true'!");
            }
            try (PreparedStatement updateStatement = this.dataManager.getAndAssertStatement("guild_json_update");){
                updateStatement.setString(1, "$." + name);
                updateStatement.setString(2, data.toString());
                updateStatement.setLong(3, this.guild.getIdLong());
                DataManager.sqlLogger.debug(DataManager.UPDATE_MARKER, "PushUpdate -> " + updateStatement);
                result = updateStatement.executeUpdate();
            }
            catch (SQLException e) {
                DataManager.logger.error(DataManager.UPDATE_MARKER, "Error while updating guild json data", (Throwable)e);
                return;
            }
        }
        DataManager.sqlLogger.debug(DataManager.UPDATE_MARKER, "ExecuteUpdate <- " + result);
    }

    private void checkSetup() {
        if (!this.setup) {
            throw new UnsupportedOperationException("GuildData has not been setup yet!");
        }
    }

    @Override
    public void close() throws Exception {
        this.temp.clear();
    }

    public String toString() {
        return "GiuldData [setup=" + this.setup + ", guild=" + this.guild + ", temp=" + this.temp + ", config=" + this.data + "]";
    }
}

