/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame.plugin;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UntrustedPluginLoader<T>
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(UntrustedPluginLoader.class);
    private static final FileFilter filter = file -> file.getPath().toLowerCase().endsWith(".jar");
    private File folder;
    private URLClassLoader loader;
    @Nonnull
    private final Class<T> pluginClass;

    public UntrustedPluginLoader(@Nonnull Class<T> pluginClass) {
        this(pluginClass, new File("plugins"));
    }

    public UntrustedPluginLoader(@Nonnull Class<T> pluginClass, @Nonnull File folder) {
        this(pluginClass, folder, true);
    }

    public UntrustedPluginLoader(@Nonnull Class<T> pluginClass, @Nonnull File folder, boolean mkdirs) {
        Objects.nonNull(pluginClass);
        this.pluginClass = pluginClass;
        this.setPluginDirectory(folder, mkdirs);
    }

    public Collection<T> getPlugins() {
        return this.getPlugins(ServiceLoader.Provider::get);
    }

    public Collection<T> getPlugins(Function<ServiceLoader.Provider<T>, T> providerMap) {
        File[] files = UntrustedPluginLoader.getJarsInFolder(this.folder);
        if (files == null || files.length == 0) {
            logger.warn("No jar files found in plugins directory");
            return Collections.emptyList();
        }
        URL[] urls = UntrustedPluginLoader.filesToURLArray(files);
        this.loader = this.createUntrustedClassLoader(urls);
        ServiceLoader<T> sl = ServiceLoader.load(this.pluginClass, this.loader);
        return sl.stream().map(providerMap).toList();
    }

    private URLClassLoader createUntrustedClassLoader(@Nonnull URL[] urls) {
        Objects.nonNull(urls);
        try {
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        URLClassLoader loader = new URLClassLoader(urls, this.getClass().getClassLoader());
        return loader;
    }

    public void setPluginDirectory(@Nonnull File folder, boolean mkdirs) {
        Objects.requireNonNull(folder);
        if (!folder.exists()) {
            if (mkdirs) {
                folder.mkdirs();
            } else {
                throw new IllegalArgumentException("File does not exist!");
            }
        }
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("File is not a folder!");
        }
        this.folder = folder;
    }

    public File getPluginDirectory() {
        return this.folder;
    }

    public Class<T> getPluginClass() {
        return this.pluginClass;
    }

    @Override
    public void close() throws Exception {
        if (this.loader != null) {
            this.loader.close();
        }
    }

    @CheckForNull
    private static File[] getJarsInFolder(@Nonnull File folder) {
        Objects.nonNull(folder);
        return folder.listFiles(filter);
    }

    @Nonnull
    private static URL[] filesToURLArray(@Nonnull File[] files) {
        Objects.nonNull(files);
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            try {
                urls[i] = files[i].toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return urls;
    }
}

