/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.events.guild.GuildLeaveEvent;
import net.dv8tion.jda.api.events.guild.GuildReadyEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.ChunkingFilter;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import net.foxgenesis.util.ProgramArguments;
import net.foxgenesis.watame.Constants;
import net.foxgenesis.watame.ExitCode;
import net.foxgenesis.watame.Main;
import net.foxgenesis.watame.command.ConfigCommand;
import net.foxgenesis.watame.command.PingCommand;
import net.foxgenesis.watame.plugin.IPlugin;
import net.foxgenesis.watame.plugin.UntrustedPluginLoader;
import net.foxgenesis.watame.sql.DataManager;
import net.foxgenesis.watame.sql.IDatabaseManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatameBot {
    public static final Logger logger = LoggerFactory.getLogger(WatameBot.class);
    private static WatameBot instance;
    private static boolean toInit;
    private JDABuilder builder;
    private JDA discord;
    private final DataManager database;
    private State state = State.CONSTRUCTING;
    private final UntrustedPluginLoader<IPlugin> loader;
    private Collection<IPlugin> plugins;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WatameBot getInstance() {
        if (!toInit) return instance;
        Class<WatameBot> clazz = WatameBot.class;
        synchronized (WatameBot.class) {
            if (!toInit) return instance;
            ProgramArguments params = Main.getProgramArguments();
            if (!params.hasParameter("token")) {
                ExitCode.NO_TOKEN.programExit("No token file specified");
            }
            String token = Objects.requireNonNull(WatameBot.readToken(params.getParameter("token")));
            try {
                logger.debug("Creating WatameBot instance");
                instance = new WatameBot(token);
                toInit = false;
            }
            catch (SQLException e) {
                ExitCode.DATABASE_NOT_CONNECTED.programExit(e);
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            return instance;
        }
    }

    private static String readToken(String filepath) {
        String string;
        logger.debug("Getting token from file");
        BufferedReader br = new BufferedReader(new FileReader(filepath));
        try {
            string = br.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                ExitCode.INVALID_TOKEN.programExit(ex);
                return null;
            }
        }
        br.close();
        return string;
    }

    private WatameBot(@Nonnull String token) throws SQLException {
        logger.debug("Adding shutdown hook");
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown, "WatameBot Shutdown Thread"));
        this.loader = new UntrustedPluginLoader<IPlugin>(IPlugin.class, Constants.PLUGINS_FOLDER, true);
        this.plugins = this.loader.getPlugins();
        this.database = new DataManager();
        this.builder = this.createJDA(token);
    }

    void start() {
        logger.info("Starting...");
        this.preInit();
    }

    private void preInit() {
        this.state = State.PRE_INIT;
        logger.trace("STATE = " + this.state);
        logger.debug("Calling plugin pre-initialization async");
        CompletableFuture<Void> pluginPreInit = CompletableFuture.allOf((CompletableFuture[])this.plugins.stream().map(plugin -> CompletableFuture.runAsync(plugin::preInit)).toArray(CompletableFuture[]::new));
        this.databaseInit();
        logger.trace("Waiting for plugin pre-initialization");
        pluginPreInit.join();
        this.init();
    }

    private void databaseInit() {
        try {
            logger.debug("Connecting to database");
            this.database.connect();
            this.database.retrieveDatabaseData(null);
        }
        catch (IOException e) {
            ExitCode.DATABASE_SETUP_ERROR.programExit(e);
        }
        catch (IllegalArgumentException e) {
            ExitCode.DATABASE_INVALID_SETUP_FILE.programExit(e);
        }
        catch (UnsupportedOperationException e) {
            ExitCode.DATABASE_NOT_CONNECTED.programExit(e);
        }
        catch (SQLException e) {
            ExitCode.DATABASE_ACCESS_ERROR.programExit(e);
        }
    }

    private void init() {
        this.state = State.INIT;
        logger.trace("STATE = " + this.state);
        logger.debug("Calling plugin initialization async");
        ProtectedJDABuilder pBuilder = new ProtectedJDABuilder(this.builder);
        CompletableFuture<Void> pluginInit = CompletableFuture.allOf((CompletableFuture[])this.plugins.stream().map(plugin -> CompletableFuture.runAsync(() -> plugin.init(pBuilder))).toArray(CompletableFuture[]::new));
        pBuilder.addEventListeners(new Object[]{new PingCommand(), new ConfigCommand()});
        logger.trace("Waiting for plugin initialization");
        pluginInit.join();
        this.postInit();
    }

    private void postInit() {
        this.state = State.POST_INIT;
        logger.trace("STATE = " + this.state);
        this.discord = this.buildJDA();
        logger.debug("Calling plugin post-initialization async");
        CompletableFuture<Void> pluginPostInit = CompletableFuture.allOf((CompletableFuture[])this.plugins.stream().map(plugin -> CompletableFuture.runAsync(() -> plugin.postInit(this))).toArray(CompletableFuture[]::new));
        this.discord.upsertCommand((CommandData)Commands.slash((String)"ping", (String)"Ping the bot to test the connection")).and(this.discord.upsertCommand((CommandData)Commands.slash((String)"config-get", (String)"Get the configuration of the bot").setDefaultPermissions(DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})).setGuildOnly(true).addOption(OptionType.STRING, "key", "Location of the variable", true, false))).and(this.discord.upsertCommand((CommandData)Commands.slash((String)"config-set", (String)"Get the configuration of the bot").setDefaultPermissions(DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR})).setGuildOnly(true).addOption(OptionType.STRING, "key", "Location of the variable", true, false).addOption(OptionType.STRING, "type", "The variable's type", true, true).addOptions(WatameBot.createAllOptions()))).queue();
        logger.trace("Waiting for plugin post-initialization");
        pluginPostInit.join();
        this.waitUntilReady();
        logger.debug("Setting presence to ready");
        this.discord.getPresence().setPresence(OnlineStatus.ONLINE, Activity.playing((String)"type <help>"));
        this.state = State.RUNNING;
        logger.trace("STATE = " + this.state);
        logger.debug("Calling plugin on ready async");
        CompletableFuture.allOf((CompletableFuture[])this.plugins.stream().map(plugin -> CompletableFuture.runAsync(() -> plugin.onReady(this), this.discord.getCallbackPool())).toArray(CompletableFuture[]::new));
    }

    private void waitUntilReady() {
        if (this.discord.getStatus() != JDA.Status.CONNECTED) {
            try {
                logger.info("Waiting for JDA to be ready...");
                this.discord.awaitReady();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.info("Connected to discord!");
    }

    private JDABuilder createJDA(String token) {
        Objects.nonNull(token);
        logger.debug("Creating JDA");
        JDABuilder builder = JDABuilder.create((String)token, (GatewayIntent)GatewayIntent.GUILD_MEMBERS, (GatewayIntent[])new GatewayIntent[]{GatewayIntent.GUILD_BANS, GatewayIntent.GUILD_MESSAGES, GatewayIntent.GUILD_MESSAGE_REACTIONS, GatewayIntent.DIRECT_MESSAGES, GatewayIntent.MESSAGE_CONTENT}).setMemberCachePolicy(MemberCachePolicy.ALL).disableCache(CacheFlag.ACTIVITY, new CacheFlag[]{CacheFlag.VOICE_STATE, CacheFlag.EMOJI, CacheFlag.STICKER, CacheFlag.CLIENT_STATUS, CacheFlag.ONLINE_STATUS}).setChunkingFilter(ChunkingFilter.NONE).setAutoReconnect(true).setActivity(Activity.playing((String)"Initializing...")).setStatus(OnlineStatus.DO_NOT_DISTURB);
        builder.addEventListeners(new Object[]{new ListenerAdapter(){

            public void onGuildReady(@Nonnull GuildReadyEvent e) {
                WatameBot.this.database.addGuild(e.getGuild());
            }

            public void onGuildLeave(@Nonnull GuildLeaveEvent e) {
                WatameBot.this.database.removeGuild(e.getGuild());
            }
        }});
        return builder;
    }

    private JDA buildJDA() {
        JDA discordTmp = null;
        boolean built = false;
        do {
            try {
                logger.info("Attempting to login to discord");
                discordTmp = this.builder.build();
                built = true;
            }
            catch (LoginException ex) {
                logger.warn("Failed to connect: " + ex.getLocalizedMessage() + " retrying...", (Throwable)ex);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (!built);
        if (discordTmp == null) {
            ExitCode.JDA_BUILD_FAIL.programExit("Failed to build JDA");
            return null;
        }
        return discordTmp;
    }

    void shutdown() {
        logger.debug("Shutting down...");
        if (this.discord != null) {
            logger.debug("Shutting down JDA...");
            this.discord.shutdown();
        }
        try {
            logger.debug("Closing database connection");
            this.database.close();
        }
        catch (Exception e) {
            logger.error("Error while closing database connection!", (Throwable)e);
        }
        logger.info("Exiting...");
    }

    public boolean isConnectedToDiscord() {
        return this.discord != null && this.discord.getStatus() == JDA.Status.CONNECTED;
    }

    public IDatabaseManager getDatabase() {
        return this.database;
    }

    public JDA getJDA() {
        return this.discord;
    }

    public State getState() {
        return this.state;
    }

    private static List<OptionData> createAllOptions() {
        OptionType[] values = OptionType.values();
        ArrayList<OptionData> list = new ArrayList<OptionData>(values.length - 3);
        for (OptionType type : values) {
            if (type == OptionType.UNKNOWN || type == OptionType.SUB_COMMAND || type == OptionType.SUB_COMMAND_GROUP) continue;
            list.add(new OptionData(type, type.name().toLowerCase(), "Value to set of type " + type.name().toLowerCase()).setAutoComplete(false).setRequired(false));
        }
        return list;
    }

    static {
        toInit = true;
    }

    public static enum State {
        CONSTRUCTING,
        PRE_INIT,
        INIT,
        POST_INIT,
        RUNNING;

    }

    public class ProtectedJDABuilder {
        private final JDABuilder builder;

        ProtectedJDABuilder(JDABuilder builder) {
            this.builder = builder;
        }

        @Nonnull
        public ProtectedJDABuilder addEventListeners(Object ... listeners) {
            this.builder.addEventListeners(listeners);
            return this;
        }

        @Nonnull
        public ProtectedJDABuilder removeEventListeners(Object ... listeners) {
            this.builder.removeEventListeners(listeners);
            return this;
        }
    }
}

