/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.watame;

import java.sql.SQLException;
import javax.annotation.Nullable;
import net.foxgenesis.util.ProgramArguments;
import net.foxgenesis.util.SingleInstanceUtil;
import net.foxgenesis.watame.ExitCode;
import net.foxgenesis.watame.WatameBot;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    public static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static ProgramArguments params;

    public static void main(String[] args) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.info("Debugging enabled");
        }
        if (!(params = new ProgramArguments(args)).hasFlag("dev")) {
            logger.trace("Installing ansi console");
            AnsiConsole.systemInstall();
        }
        System.out.println();
        try {
            logger.debug("Attempting to obtain instance lock");
            SingleInstanceUtil.waitAndGetLock(5);
        }
        catch (SingleInstanceUtil.SingleInstanceLockException e) {
            ExitCode.INSTANCE_ALREADY_RUNNING.programExit("Another instance is already running! Exiting...");
            return;
        }
        WatameBot watame = WatameBot.getInstance();
        watame.start();
        logger.info("Startup Complete!");
    }

    @Nullable
    static ProgramArguments getProgramArguments() {
        return params;
    }
}

