/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.util;

import java.util.function.Predicate;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class StringUtils {
    public static final Pattern PATTERN_URL = Pattern.compile("\\b((http|https|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])", 2);
    public static final Pattern PATTERN_URL_WITH_GROUPING = Pattern.compile("\\b(?<protocol>http[s]?|ftp|file)://(?<domain>[-a-zA-Z0-9+&@#%?=~_|!:,.;]*[-a-zA-Z0-9+&@#%=~_|])(?<path>\\S*)", 2);
    public static final Predicate<String> CONTAINS_URL = PATTERN_URL.asPredicate();

    public static Stream<MatchResult> findURLWithGroups(@Nonnull String str) {
        return PATTERN_URL_WITH_GROUPING.matcher(str).results();
    }
}

