/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.config.fields;

import java.util.function.Function;
import javax.annotation.CheckForNull;
import net.dv8tion.jda.api.entities.Channel;
import net.dv8tion.jda.api.entities.Guild;
import net.foxgenesis.config.fields.ConfigField;
import net.foxgenesis.config.fields.JSONObjectAdv;

public class ChannelField
extends ConfigField<Channel> {
    public ChannelField(String name, Function<Guild, Channel> defaultValue, boolean isEditable) {
        super(name, defaultValue, isEditable);
    }

    @Override
    @CheckForNull
    Channel optFrom(JSONObjectAdv config, Guild guild) {
        long id = config.optLong(this.name);
        if (id == 0L) {
            return (Channel)this.getDefaultValue(guild);
        }
        return id == 0L ? (Channel)this.getDefaultValue(guild) : guild.getTextChannelById(id);
    }

    @Override
    @CheckForNull
    Channel from(JSONObjectAdv config, Guild guild) {
        return guild.getTextChannelById(config.getLong(this.name));
    }

    @Override
    void set(JSONObjectAdv config, Channel newState) {
        config.put(this.name, newState.getIdLong());
    }
}

