/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.foxgenesis.util.ResourceHelper;

public class KVPFile {
    private static final Predicate<String> ignoreLines = line -> line.matches("^(.+?)=(.*?)$");
    private final URL resourceURL;
    private final HashMap<String, String> config = new HashMap();

    public KVPFile(@Nonnull File file) throws MalformedURLException {
        this(file.toURI().toURL());
    }

    public KVPFile(@Nonnull URL url) {
        Objects.nonNull(url);
        this.resourceURL = url;
    }

    public void forEach(BiConsumer<? super String, ? super String> action) {
        this.config.forEach(action);
    }

    @Nullable
    public String get(String key) {
        return this.config.get(key);
    }

    @Nullable
    public String getOrDefault(String key, String defaultValue) {
        return this.config.getOrDefault(key, defaultValue);
    }

    public boolean containsKey(String key) {
        return this.config.containsKey(key);
    }

    public void clear() {
        this.config.clear();
    }

    public boolean isEmpty() {
        return this.config.isEmpty();
    }

    public void parse() throws IOException {
        Map<String, String> tempMap = ResourceHelper.linesFromResource(this.resourceURL).stream().filter(ignoreLines).map(line -> line.split("=", 2)).filter(split -> ((String[])split).length == 2).collect(Collectors.toMap(split -> split[0].trim(), split -> split[1].trim()));
        this.config.putAll(tempMap);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.resourceURL);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KVPFile other = (KVPFile)obj;
        return Objects.equals(this.config, other.config) && Objects.equals(this.resourceURL, other.resourceURL);
    }

    public String toString() {
        return "KVPFile [resourceURL=" + this.resourceURL + ", config=" + this.config + "]";
    }
}

