/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.sparql.etc;

import info.aduna.io.IOUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.fortytwo.stream.StreamProcessor;
import net.fortytwo.stream.sparql.etc.ErrorTolerantValueFactory;
import net.fortytwo.stream.sparql.impl.caching.CachingSparqlStreamProcessor;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.SimpleValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.BasicParserSettings;

public class TestRunner {
    private static final int TUPLE_TTL = 0;
    private static final int QUERY_TTL = 0;

    public static void main(String[] args) throws Exception {
        if (2 != args.length) {
            TestRunner.printUsageAndExit();
        }
        try {
            List<String> queryFiles = TestRunner.getLines(args[0]);
            List<String> dataFiles = TestRunner.getLines(args[1]);
            TestRunner.doRun(queryFiles, dataFiles);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static void doRun(List<String> queryFiles, List<String> dataFiles) throws IOException, MalformedQueryException, StreamProcessor.IncompatibleQueryException, RDFHandlerException, StreamProcessor.InvalidQueryException {
        CachingSparqlStreamProcessor engine = new CachingSparqlStreamProcessor();
        String baseIri = "http://example.org/base-iri/";
        BiConsumer<BindingSet, Long> solutionConsumer = (result, expirationTime) -> {
            StringBuilder sb = new StringBuilder("RESULT\t" + System.currentTimeMillis() + "\t" + expirationTime + "\t");
            boolean first = true;
            for (String n : result.getBindingNames()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(n).append(":").append(result.getValue(n));
            }
            System.out.println(sb);
        };
        for (String f : queryFiles) {
            System.out.println("RUN\t" + System.currentTimeMillis() + "\tadding query file " + f);
            FileInputStream in = new FileInputStream(new File(f));
            Throwable throwable = null;
            try {
                String query = IOUtil.readString((InputStream)in);
                engine.addQuery(0, query, solutionConsumer);
            }
            catch (Throwable query) {
                throwable = query;
                throw query;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable query) {
                        throwable.addSuppressed(query);
                    }
                    continue;
                }
                ((InputStream)in).close();
            }
        }
        for (String f : dataFiles) {
            System.out.println("RUN\t" + System.currentTimeMillis() + "\tadding data file " + f);
            Optional format = RDFParserRegistry.getInstance().getFileFormatForFileName(f);
            if (!format.isPresent()) {
                System.err.println("no RDF format matching file name " + f);
                continue;
            }
            RDFHandler handler = engine.createRDFHandler(0);
            FileInputStream in = new FileInputStream(new File(f));
            Throwable throwable = null;
            try {
                RDFParser p = Rio.createParser((RDFFormat)((RDFFormat)format.get()));
                p.setValueFactory((ValueFactory)new ErrorTolerantValueFactory((ValueFactory)SimpleValueFactory.getInstance()));
                p.getParserConfig().set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)false);
                p.setRDFHandler(handler);
                try {
                    p.parse((InputStream)in, baseIri);
                }
                catch (RDFParseException e) {
                    System.err.println("RUN ERROR: parse error: " + e.getMessage());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)in).close();
            }
        }
        engine.shutDown();
        System.out.println("RUN\t" + System.currentTimeMillis() + "\tfinished");
    }

    private static List<String> getLines(String fileName) throws IOException {
        LinkedList<String> lines = new LinkedList<String>();
        try (FileInputStream in = new FileInputStream(new File(fileName));){
            String line;
            BufferedReader b = new BufferedReader(new InputStreamReader(in));
            while (null != (line = b.readLine())) {
                lines.add(line.trim());
            }
        }
        return lines;
    }

    private static void printUsageAndExit() {
        System.err.println("Usage: TestRunner list-of-queries.txt list-of-data-files.txt");
        System.exit(1);
    }
}

