/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.sparql;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import net.fortytwo.stream.BasicStreamProcessor;
import net.fortytwo.stream.BasicSubscription;
import net.fortytwo.stream.StreamProcessor;
import net.fortytwo.stream.Subscription;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;

public abstract class RDFStreamProcessor<C, Q>
extends BasicStreamProcessor<String, C, Q, Statement, BindingSet> {
    protected static final Logger logger = Logger.getLogger(RDFStreamProcessor.class.getName());
    private Supplier<Long> clock;
    private boolean logHasChanged;
    private final Map<Quantity, Counter> counters;
    private long startTime;
    private final Counter countQueries = new Counter();
    private final Counter countStatements = new Counter();
    private final Counter countSolutions = new Counter();
    private boolean useCompactLogFormat = true;
    private boolean performanceMetrics = false;
    private boolean active = true;

    protected boolean isActive() {
        return this.active;
    }

    public void shutDown() {
        this.active = false;
    }

    protected RDFStreamProcessor() {
        this.counters = new LinkedHashMap<Quantity, Counter>();
        this.counters.put(Quantity.Queries, this.countQueries);
        this.counters.put(Quantity.Inputs, this.countStatements);
        this.counters.put(Quantity.Solutions, this.countSolutions);
        this.clock = System::currentTimeMillis;
    }

    protected abstract C parseQuery(String var1) throws StreamProcessor.InvalidQueryException, StreamProcessor.IncompatibleQueryException;

    protected abstract BasicSubscription<C, Q, BindingSet> createSubscription(int var1, C var2, BiConsumer<BindingSet, Long> var3);

    protected abstract boolean addTuple(Value[] var1, int var2, long var3);

    public void setClock(Supplier<Long> clock) {
        this.clock = clock;
    }

    public void setDoUseCompactLogFormat(boolean b) {
        this.useCompactLogFormat = b;
    }

    public void setDoPerformanceMetrics(boolean b) {
        this.performanceMetrics = b;
    }

    public Subscription addQuery(int ttl, String queryStr, BiConsumer<BindingSet, Long> consumer) throws StreamProcessor.IncompatibleQueryException, StreamProcessor.InvalidQueryException, IOException {
        return this.addQueryNative(ttl, this.parseQuery(queryStr), consumer);
    }

    protected Subscription addQueryNative(int ttl, C sparqlQuery, BiConsumer<BindingSet, Long> consumer) throws IOException {
        this.incrementQueries();
        BasicSubscription<C, Q, BindingSet> sub = this.createSubscription(ttl, sparqlQuery, consumer);
        this.logEntry();
        return sub;
    }

    public long get(Quantity quantity) {
        if (!this.performanceMetrics) {
            throw new IllegalStateException("performance metrics are disabled; quantities are not counted");
        }
        Counter counter = this.counters.get((Object)quantity);
        if (null == counter) {
            throw new IllegalArgumentException("no counter for quantity: " + (Object)((Object)quantity));
        }
        return counter.count;
    }

    public boolean addInputs(int ttl, Statement ... inputs) {
        boolean changed = false;
        for (Statement s : inputs) {
            this.incrementStatements();
            long now = this.beginOperation();
            Value[] tuple = this.toNative(s);
            changed |= this.addTuple(tuple, ttl, now);
            this.logEntry();
        }
        return changed;
    }

    private Value[] toNative(Statement s) {
        return new Value[]{s.getSubject(), s.getPredicate(), s.getObject()};
    }

    protected void increment(Counter counter, boolean logChange) {
        if (this.performanceMetrics) {
            counter.increment();
            if (logChange) {
                this.logHasChanged = true;
            }
        }
    }

    protected void incrementQueries() {
        this.increment(this.countQueries, true);
    }

    protected void incrementStatements() {
        this.increment(this.countStatements, false);
    }

    protected void incrementSolutions() {
        this.increment(this.countSolutions, true);
    }

    protected long beginOperation() {
        long now;
        this.startTime = now = this.getNow();
        return now;
    }

    protected long getNow() {
        return this.clock.get();
    }

    protected void logEntry() {
        if (this.performanceMetrics && (!this.useCompactLogFormat || this.logHasChanged)) {
            StringBuilder sb = new StringBuilder("LOG\t");
            sb.append(this.startTime).append(",").append(this.getNow());
            for (Map.Entry<Quantity, Counter> entry : this.counters.entrySet()) {
                sb.append(",").append(entry.getValue().count);
            }
            System.out.println(sb.toString());
            this.logHasChanged = false;
        }
    }

    protected void logHeader() {
        if (this.performanceMetrics) {
            StringBuilder sb = new StringBuilder("LOG\ttime1,time2");
            for (Quantity q : this.counters.keySet()) {
                sb.append(",").append(q.name());
            }
            System.out.println(sb.toString());
        }
    }

    protected long toExpirationTime(int ttl, long now) {
        return 0 == ttl ? Long.MAX_VALUE : now + 1000L * (long)ttl;
    }

    private static String toString(BindingSet b) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String n : b.getBindingNames()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(n).append(":").append(b.getValue(n));
        }
        return sb.toString();
    }

    protected void handleSolution(BiConsumer<BindingSet, Long> consumer, BindingSet solution, long expirationTime) {
        this.incrementSolutions();
        if (this.performanceMetrics) {
            System.out.println("SOLUTION\t" + this.getNow() + "\t" + RDFStreamProcessor.toString(solution));
        }
        consumer.accept(solution, expirationTime);
    }

    protected void clearCounters() {
        this.countQueries.reset();
        this.countStatements.reset();
        this.countSolutions.reset();
        this.logHeader();
    }

    protected static class Counter {
        private long count = 0L;

        protected Counter() {
        }

        public void increment() {
            ++this.count;
        }

        public void reset() {
            this.count = 0L;
        }

        public long getCount() {
            return this.count;
        }
    }

    public static enum Quantity {
        Queries,
        Inputs,
        Solutions;

    }
}

