/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream;

import java.util.Collection;
import java.util.List;
import net.fortytwo.stream.StreamProcessor;
import net.fortytwo.stream.sparql.etc.SparqlTestBase;
import net.fortytwo.stream.sparql.impl.caching.CachingSparqlStreamProcessor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openrdf.model.Statement;
import org.openrdf.query.BindingSet;
import org.openrdf.sail.memory.MemoryStore;

public class SP2BenchIT
extends SparqlTestBase {
    private static final boolean DEBUG = true;
    private final List<Statement> data = this.loadData("/tmp/sp2bench-50000.nt");

    @Before
    public void setUp() throws Exception {
        this.sail = new MemoryStore();
        this.sail.initialize();
        this.queryEngine = new CachingSparqlStreamProcessor();
    }

    @After
    public void tearDown() throws Exception {
        this.sail.shutDown();
    }

    @Test
    public void testQuery1() throws Exception {
        Collection answers = this.continuousQueryAnswers(this.data, this.loadQuery("sp2bench/q1.rq"), true);
        Assert.assertEquals((long)1L, (long)answers.size());
        Assert.assertEquals((Object)"1940", (Object)((BindingSet)answers.iterator().next()).getValue("yr").stringValue());
    }

    @Test(expected=StreamProcessor.IncompatibleQueryException.class)
    public void testQuery2() throws Exception {
        this.continuousQueryAnswers(this.data, this.loadQuery("sp2bench/q2.rq"), false);
    }

    @Test
    public void testQuery3a() throws Exception {
        Collection answers = this.continuousQueryAnswers(this.data, this.loadQuery("sp2bench/q3a.rq"), true);
        Assert.assertEquals((long)3647L, (long)answers.size());
    }

    @Test
    public void testQuery3b() throws Exception {
        Collection answers = this.continuousQueryAnswers(this.data, this.loadQuery("sp2bench/q3b.rq"), true);
        Assert.assertEquals((long)25L, (long)answers.size());
    }

    @Test
    public void testQuery3c() throws Exception {
        Collection answers = this.continuousQueryAnswers(this.data, this.loadQuery("sp2bench/q3c.rq"), true);
        Assert.assertEquals((long)0L, (long)answers.size());
    }

    @Test
    public void testQuery12c() throws Exception {
        Collection answers = this.continuousQueryAnswers(this.data, this.loadQuery("sp2bench/q12c.rq"), true);
        Assert.assertEquals((long)0L, (long)answers.size());
    }
}

