/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream;

import net.fortytwo.linkeddata.LinkedDataCache;
import net.fortytwo.stream.sparql.etc.SparqlTestBase;
import net.fortytwo.stream.sparql.impl.caching.CachingSparqlStreamProcessor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.openrdf.model.Statement;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class LinkedDataIT
extends SparqlTestBase {
    @Before
    public void setUp() throws Exception {
        this.sail = new MemoryStore();
        this.sail.initialize();
        this.queryEngine = new CachingSparqlStreamProcessor();
    }

    @After
    public void tearDown() throws Exception {
        this.sail.shutDown();
    }

    @Test
    public void testSimple() throws Exception {
        LinkedDataCache.DataStore store = sc -> statement -> this.queryEngine.addInputs(0, new Statement[]{statement});
        LinkedDataCache cache = LinkedDataCache.createDefault((Sail)this.sail);
        cache.setDataStore(store);
        this.queryEngine.setLinkedDataCache(cache);
        TupleExpr query = this.loadQuery("linked-data-join-1.rq");
        this.queryEngine.addQuery(0, query, this.simpleConsumer);
        for (Statement s : this.loadData("example.nq")) {
            this.queryEngine.addInputs(0, new Statement[]{s});
        }
    }
}

