/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.sparql.impl.shj;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.fortytwo.stream.BasicStreamProcessor;
import net.fortytwo.stream.BasicSubscription;
import net.fortytwo.stream.model.VariableOrConstant;
import net.fortytwo.stream.shj.ExpirationManager;
import net.fortytwo.stream.shj.GraphPattern;
import net.fortytwo.stream.shj.Index;
import net.fortytwo.stream.shj.Query;
import net.fortytwo.stream.shj.QueryContext;
import net.fortytwo.stream.shj.QueryIndex;
import net.fortytwo.stream.shj.Solution;
import net.fortytwo.stream.shj.TuplePattern;
import net.fortytwo.stream.sparql.SparqlQuery;
import net.fortytwo.stream.sparql.SparqlStreamProcessor;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.impl.MapBindingSet;

public class SHJSparqlStreamProcessor
extends SparqlStreamProcessor<Query<String, Value>> {
    private final QueryContext<String, Value> context;
    private final QueryIndex<String, Value> queryIndex;

    public SHJSparqlStreamProcessor() {
        ExpirationManager<Query<String, Value>> queryExpirationManager = new ExpirationManager<Query<String, Value>>(){

            protected long getNow() {
                return SHJSparqlStreamProcessor.this.getNow();
            }
        };
        queryExpirationManager.setVerbose(true);
        ExpirationManager<Solution<Value>> solutionExpirationManager = new ExpirationManager<Solution<Value>>(){

            protected long getNow() {
                return SHJSparqlStreamProcessor.this.getNow();
            }
        };
        solutionExpirationManager.setVerbose(true);
        this.context = new QueryContext((ExpirationManager)queryExpirationManager, (ExpirationManager)solutionExpirationManager);
        this.queryIndex = new QueryIndex(this.context);
    }

    public void clear() {
        this.queryIndex.clear();
        this.context.clear();
    }

    @Override
    protected boolean addTupleInternal(Value[] tuple, int ttl, long now) {
        long expirationTime = this.toExpirationTime(ttl, now);
        return this.queryIndex.add((Object[])tuple, expirationTime);
    }

    @Override
    protected void register(BasicSubscription<SparqlQuery, Query<String, Value>, BindingSet> subscription) {
        Query query = (Query)subscription.getQuery();
        this.queryIndex.add(query);
    }

    public void unregister(BasicSubscription<SparqlQuery, Query<String, Value>, BindingSet> subscription) {
        this.queryIndex.remove((Query)subscription.getQuery());
    }

    public boolean renew(BasicSubscription<SparqlQuery, Query<String, Value>, BindingSet> subscription, int ttl) {
        throw new UnsupportedOperationException("query renewal is not yet supported; remove the query and add a new one");
    }

    @Override
    protected void visitQueryPatterns(Query<String, Value> query, Consumer<VariableOrConstant<String, Value>[]> visitor) {
        for (TuplePattern tuplePattern : query.getGraphPattern().getPatterns()) {
            visitor.accept(tuplePattern.getPattern());
        }
    }

    @Override
    protected BasicSubscription<SparqlQuery, Query<String, Value>, BindingSet> createSubscriptionInternal(SparqlQuery sparqlQuery, List<VariableOrConstant<String, Value>[]> patterns, long expirationTime, BiConsumer<BindingSet, Long> consumer) {
        BasicSubscription subscription = new BasicSubscription((Object)sparqlQuery, null, null, (BasicStreamProcessor)this);
        BiConsumer<Map, Long> solutionHandler = (mapping, expirationTime1) -> {
            BindingSet solution = this.toBindingSet((Map<String, Value>)mapping);
            try {
                this.handleCandidateSolution(subscription, solution, (long)expirationTime1);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "failed to handle solution " + solution, e);
            }
        };
        TuplePattern[] tuplePatterns = new TuplePattern[patterns.size()];
        int i = 0;
        for (VariableOrConstant<String, Value>[] p : patterns) {
            tuplePatterns[i++] = new TuplePattern(p);
        }
        GraphPattern graphPattern = new GraphPattern(tuplePatterns);
        Query query = new Query(graphPattern, expirationTime, (Index)this.context.getQueryExpirationManager(), solutionHandler);
        subscription.setQuery((Object)query);
        subscription.setSolutionConsumer(consumer);
        return subscription;
    }

    private BindingSet toBindingSet(Map<String, Value> mapping) {
        MapBindingSet bs = new MapBindingSet();
        for (Map.Entry<String, Value> e : mapping.entrySet()) {
            bs.addBinding(e.getKey(), e.getValue());
        }
        return bs;
    }
}

