/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.sparql.etc;

import info.aduna.io.IOUtil;
import info.aduna.iteration.CloseableIteration;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.fortytwo.stream.sparql.RDFStreamProcessor;
import net.fortytwo.stream.sparql.SparqlStreamProcessor;
import net.fortytwo.stream.sparql.etc.StatementCollector;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.SimpleValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.query.impl.SimpleDataset;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.QueryParser;
import org.openrdf.query.parser.sparql.SPARQLParser;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;

public class SparqlTestBase {
    private static final String BASE_IRI = "http://example.org/base/";
    private final QueryParser queryParser = new SPARQLParser();
    protected Sail sail;
    protected SparqlStreamProcessor queryEngine;
    protected final ValueFactory valueFactory = SimpleValueFactory.getInstance();
    protected final int TUPLE_TTL = 0;
    protected final int QUERY_TTL = 0;
    protected final BiConsumer<BindingSet, Long> simpleConsumer = (result, expirationTime) -> System.out.println("result: " + result + ", expires at " + expirationTime);

    protected TupleExpr loadQuery(String fileName) throws Exception {
        InputStream in = RDFStreamProcessor.class.getResourceAsStream(fileName);
        String query = IOUtil.readString((InputStream)in);
        in.close();
        ParsedQuery pq = this.queryParser.parseQuery(query, BASE_IRI);
        return pq.getTupleExpr();
    }

    protected List<Statement> loadData(String fileName) throws Exception {
        Optional format = RDFParserRegistry.getInstance().getFileFormatForFileName(fileName);
        if (!format.isPresent()) {
            throw new IllegalStateException("unsupported file extension");
        }
        RDFParser p = Rio.createParser((RDFFormat)((RDFFormat)format.get()));
        p.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)false);
        LinkedList<Statement> c = new LinkedList<Statement>();
        p.setRDFHandler((RDFHandler)new StatementCollector(c));
        InputStream in = fileName.startsWith("/") ? new FileInputStream(new File(fileName)) : RDFStreamProcessor.class.getResourceAsStream(fileName);
        p.parse(in, BASE_IRI);
        in.close();
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<BindingSet>[] distinctStaticQueryAnswers(List<Statement> data, TupleExpr ... queries) {
        Set[] answers = new Set[queries.length];
        int i = 0;
        for (TupleExpr query : queries) {
            HashSet<Object> results;
            answers[i] = results = new HashSet<Object>();
            SailConnection sc = this.sail.getConnection();
            try {
                sc.begin();
                for (Statement s : data) {
                    sc.addStatement(s.getSubject(), s.getPredicate(), s.getObject(), new Resource[]{s.getContext()});
                }
                try (CloseableIteration iter = sc.evaluate(query, (Dataset)new SimpleDataset(), (BindingSet)new EmptyBindingSet(), false);){
                    while (iter.hasNext()) {
                        results.add(iter.next());
                    }
                }
            }
            finally {
                sc.rollback();
                sc.close();
            }
            ++i;
        }
        return answers;
    }

    protected Set<BindingSet>[] distinctContinuousQueryAnswers(List<Statement> data, TupleExpr ... queries) throws Exception {
        final Set[] answers = new Set[queries.length];
        this.queryEngine.clear();
        int i = 0;
        for (TupleExpr tupleExpr : queries) {
            answers[i] = new HashSet();
            final int id = i++;
            BiConsumer<BindingSet, Long> solutionConsumer = new BiConsumer<BindingSet, Long>(){
                private final Set<BindingSet> a;
                {
                    this.a = answers[id];
                }

                @Override
                public void accept(BindingSet result, Long expirationTime) {
                    System.out.println("result: " + result);
                    this.a.add(result);
                }
            };
            this.queryEngine.addQuery(0, tupleExpr, solutionConsumer);
        }
        for (Statement s : data) {
            this.queryEngine.addInputs(0, s);
        }
        return answers;
    }

    protected Collection<BindingSet> continuousQueryAnswers(List<Statement> data, TupleExpr query, boolean debug) throws Exception {
        LinkedList<BindingSet> answers = new LinkedList<BindingSet>();
        this.queryEngine.clear();
        BiConsumer<BindingSet, Long> solutionConsumer = (result, expirationTime) -> {
            if (debug) {
                System.out.println("result: " + result + ", expires at " + expirationTime);
            }
            answers.add((BindingSet)result);
        };
        this.queryEngine.addQuery(0, query, solutionConsumer);
        for (Statement s : data) {
            this.queryEngine.addInputs(0, s);
        }
        return answers;
    }
}

