/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.sparql;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.fortytwo.linkeddata.LinkedDataCache;
import net.fortytwo.stream.BasicSubscription;
import net.fortytwo.stream.StreamProcessor;
import net.fortytwo.stream.Subscription;
import net.fortytwo.stream.model.LList;
import net.fortytwo.stream.model.VariableOrConstant;
import net.fortytwo.stream.sparql.RDFStreamProcessor;
import net.fortytwo.stream.sparql.SparqlQuery;
import net.fortytwo.stream.sparql.etc.FilterEvaluator;
import org.openrdf.model.IRI;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.SimpleValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.QueryParserUtil;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public abstract class SparqlStreamProcessor<Q>
extends RDFStreamProcessor<SparqlQuery, Q> {
    private static long reducedModifierCapacity = 1000L;
    private final FilterEvaluator filterEvaluator;
    private ExecutorService linkedDataService;
    private final int httpThreadPoolSize = Runtime.getRuntime().availableProcessors() + 1;
    private LinkedDataCache linkedDataCache;

    public static long getReducedModifierCapacity() {
        return reducedModifierCapacity;
    }

    public static void setReducedModifierCapacity(long capacity) {
        if (capacity < 1L) {
            throw new IllegalArgumentException("unreasonable REDUCED capacity value: " + capacity);
        }
        reducedModifierCapacity = capacity;
    }

    protected SparqlStreamProcessor() {
        SimpleValueFactory valueFactory = SimpleValueFactory.getInstance();
        this.filterEvaluator = new FilterEvaluator((ValueFactory)valueFactory);
    }

    protected abstract void visitQueryPatterns(Q var1, Consumer<VariableOrConstant<String, Value>[]> var2);

    protected abstract boolean addTupleInternal(Value[] var1, int var2, long var3);

    protected abstract void register(BasicSubscription<SparqlQuery, Q, BindingSet> var1);

    protected abstract BasicSubscription<SparqlQuery, Q, BindingSet> createSubscriptionInternal(SparqlQuery var1, List<VariableOrConstant<String, Value>[]> var2, long var3, BiConsumer<BindingSet, Long> var5);

    @Override
    protected boolean addTuple(Value[] tuple, int ttl, long now) {
        boolean changed = this.addTupleInternal(tuple, ttl, now);
        if (changed && null != this.linkedDataCache) {
            this.triggerLinkedDataCache(tuple);
        }
        return changed;
    }

    public RDFHandler createRDFHandler(final int ttl) {
        return new RDFHandler(){

            public void startRDF() throws RDFHandlerException {
            }

            public void endRDF() throws RDFHandlerException {
            }

            public void handleNamespace(String s, String s1) throws RDFHandlerException {
            }

            public void handleStatement(Statement s) throws RDFHandlerException {
                try {
                    SparqlStreamProcessor.this.addInputs(ttl, s);
                }
                catch (Throwable t) {
                    throw new RDFHandlerException(t);
                }
            }

            public void handleComment(String s) throws RDFHandlerException {
            }
        };
    }

    public void setLinkedDataCache(LinkedDataCache cache) {
        this.linkedDataCache = cache;
        this.linkedDataCache.setAutoCommit(true);
        boolean staticTtl = false;
        LinkedDataCache.DataStore store = sc -> this.createRDFSink(0);
        cache.setDataStore(store);
        if (null != this.linkedDataService) {
            this.linkedDataService.shutdown();
        }
        this.linkedDataService = Executors.newFixedThreadPool(this.httpThreadPoolSize);
    }

    public Subscription addQuery(int ttl, TupleExpr tupleExpr, BiConsumer<BindingSet, Long> consumer) throws StreamProcessor.IncompatibleQueryException, IOException {
        SparqlQuery sparqlQuery = new SparqlQuery(tupleExpr);
        return this.addQueryNative(ttl, sparqlQuery, consumer);
    }

    @Override
    protected BasicSubscription<SparqlQuery, Q, BindingSet> createSubscription(int ttl, SparqlQuery sparqlQuery, BiConsumer<BindingSet, Long> consumer) {
        long expirationTime = this.toExpirationTime(ttl, this.getNow());
        LinkedList<VariableOrConstant<String, Value>[]> patterns = new LinkedList<VariableOrConstant<String, Value>[]>();
        LList tPatterns = sparqlQuery.getTriplePatterns();
        while (!tPatterns.isNil()) {
            patterns.add((VariableOrConstant<String, Value>[])tPatterns.getValue());
            tPatterns = tPatterns.getRest();
        }
        BasicSubscription<SparqlQuery, Q, BindingSet> sub = this.createSubscriptionInternal(sparqlQuery, patterns, expirationTime, consumer);
        if (null != this.linkedDataCache) {
            this.clearLinkedDataCache();
            this.visitQueryPatterns(sub.getQuery(), this::triggerLinkedDataCache);
        }
        this.register(sub);
        return sub;
    }

    @Override
    protected SparqlQuery parseQuery(String queryStr) throws StreamProcessor.InvalidQueryException, StreamProcessor.IncompatibleQueryException {
        ParsedQuery parsedQuery;
        String baseIRI = "http://example.org/baseIRI";
        try {
            parsedQuery = QueryParserUtil.parseQuery((QueryLanguage)QueryLanguage.SPARQL, (String)queryStr, (String)baseIRI);
        }
        catch (MalformedQueryException e) {
            throw new StreamProcessor.InvalidQueryException((Throwable)e);
        }
        return new SparqlQuery(parsedQuery.getTupleExpr());
    }

    /*
     * WARNING - void declaration
     */
    protected void handleCandidateSolution(BasicSubscription<SparqlQuery, Q, BindingSet> subscription, BindingSet bs, long expirationTime) throws IOException {
        SparqlQuery.QueryForm queryForm;
        SparqlQuery sparqlQuery = (SparqlQuery)subscription.getConstraint();
        if (!subscription.isActive()) {
            return;
        }
        List<Filter> filters = sparqlQuery.getFilters();
        if (null != filters) {
            for (Filter filter : filters) {
                try {
                    if (this.filterEvaluator.applyFilter(filter, bs)) continue;
                    return;
                }
                catch (QueryEvaluationException queryEvaluationException) {
                    logger.log(Level.SEVERE, "query evaluation error while applying filter", queryEvaluationException);
                    return;
                }
            }
        }
        MapBindingSet solution = new MapBindingSet();
        for (String string : sparqlQuery.getBindingNames()) {
            void var9_13;
            String keyp;
            Value value = bs.getValue(string);
            if (null == value) continue;
            if (null != sparqlQuery.getExtendedBindingNames() && null != (keyp = sparqlQuery.getExtendedBindingNames().get(string))) {
                String string2 = keyp;
            }
            solution.addBinding((String)var9_13, value);
        }
        if (null != sparqlQuery.getConstants()) {
            for (Map.Entry<String, Value> entry : sparqlQuery.getConstants().entrySet()) {
                solution.addBinding(entry.getKey(), entry.getValue());
            }
        }
        if (SparqlQuery.QueryForm.SELECT == (queryForm = sparqlQuery.getQueryForm())) {
            if (sparqlQuery.getSequenceModifier().trySolution((BindingSet)solution, (Subscription)subscription)) {
                this.handleSolution(subscription.getSolutionConsumer(), (BindingSet)solution, expirationTime);
            }
        } else {
            throw new IllegalStateException("unexpected query form: " + (Object)((Object)queryForm));
        }
    }

    private void triggerLinkedDataCache(VariableOrConstant<String, Value>[] pattern) {
        if (pattern.length >= 1) {
            Value object;
            Value subject = (Value)pattern[0].getConstant();
            if (null != subject && subject instanceof IRI) {
                this.indexLinkedDataIri((IRI)subject);
            }
            if (pattern.length >= 3 && null != (object = (Value)pattern[2].getConstant()) && object instanceof IRI) {
                this.indexLinkedDataIri((IRI)object);
            }
        }
    }

    private void triggerLinkedDataCache(Value[] tuple) {
        if (tuple.length >= 3) {
            Value subject = tuple[0];
            Value object = tuple[2];
            if (subject instanceof IRI && object instanceof IRI) {
                boolean objectExists;
                boolean subjectExists;
                try {
                    subjectExists = null != this.linkedDataCache.peek((IRI)subject, this.linkedDataCache.getSailConnection());
                    objectExists = null != this.linkedDataCache.peek((IRI)object, this.linkedDataCache.getSailConnection());
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "failed to dereference (" + subject + "," + object + "): " + e.getMessage());
                    return;
                }
                if (subjectExists && !objectExists) {
                    this.indexLinkedDataIri((IRI)object);
                } else if (objectExists && !subjectExists) {
                    this.indexLinkedDataIri((IRI)subject);
                }
            }
        }
    }

    private void indexLinkedDataIri(IRI iri) {
        if (this.isHttpIri(iri)) {
            this.linkedDataService.execute(() -> {
                try {
                    this.linkedDataCache.retrieve(iri, this.linkedDataCache.getSailConnection());
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "failed to retrieve IRI", e);
                }
            });
        }
    }

    private boolean isHttpIri(IRI iri) {
        String s = iri.stringValue();
        return s.startsWith("http://") || s.startsWith("https://");
    }

    private void clearLinkedDataCache() {
        this.linkedDataCache.clear();
    }

    private Consumer<Statement> createRDFSink(int ttl) {
        return statement -> this.addInputs(ttl, (Statement)statement);
    }
}

