/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream;

import info.aduna.io.IOUtil;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.fortytwo.stream.StreamProcessor;
import net.fortytwo.stream.sparql.RDFStreamProcessor;
import net.fortytwo.stream.sparql.SparqlStreamProcessor;
import net.fortytwo.stream.sparql.etc.SparqlTestBase;
import net.fortytwo.stream.sparql.impl.caching.CachingSparqlStreamProcessor;
import net.fortytwo.stream.sparql.impl.shj.SHJSparqlStreamProcessor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openrdf.model.IRI;
import org.openrdf.model.Statement;
import org.openrdf.query.BindingSet;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.sail.memory.MemoryStore;

public class SparqlStreamProcessorTest
extends SparqlTestBase {
    private static final int QUERY_TTL = 0;
    private static final String[] LUBM_QUERIES = new String[]{"q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q11", "q12", "q13", "q14"};
    private static final String[] INVALID_QUERIES = new String[]{"construct-incomplete"};
    private static final String[] INCOMPATIBLE_QUERIES = new String[]{"not-equal-filters"};
    private final String ex = "http://example.org/";
    private final String foaf = "http://xmlns.com/foaf/0.1/";
    private IRI arthur = this.valueFactory.createIRI("http://example.org/arthur");
    private IRI zaphod = this.valueFactory.createIRI("http://example.org/zaphod");
    private IRI ford = this.valueFactory.createIRI("http://example.org/ford");
    private IRI knows = this.valueFactory.createIRI("http://xmlns.com/foaf/0.1/knows");

    @Before
    public void setUp() throws Exception {
        this.sail = new MemoryStore();
        this.sail.initialize();
        this.queryEngine = new SHJSparqlStreamProcessor();
    }

    @After
    public void tearDown() throws Exception {
        this.sail.shutDown();
    }

    @Test
    public void testAddLubmQueries() throws Exception {
        CachingSparqlStreamProcessor engine = new CachingSparqlStreamProcessor();
        BiConsumer<BindingSet, Long> bsh = (result, expirationTime) -> {};
        for (String q : LUBM_QUERIES) {
            String name = "lubm/" + q + ".rq";
            try (InputStream in = RDFStreamProcessor.class.getResourceAsStream(name);){
                String query = IOUtil.readString((InputStream)in);
                engine.addQuery(0, query, bsh);
            }
        }
    }

    @Test
    public void testInvalidQueries() throws Exception {
        CachingSparqlStreamProcessor engine = new CachingSparqlStreamProcessor();
        BiConsumer<BindingSet, Long> bsh = (result, expirationTime) -> {};
        for (String q : INVALID_QUERIES) {
            String name = "invalid/" + q + ".rq";
            boolean invalid = false;
            try (InputStream in = RDFStreamProcessor.class.getResourceAsStream(name);){
                String query = IOUtil.readString((InputStream)in);
                try {
                    engine.addQuery(0, query, bsh);
                }
                catch (StreamProcessor.InvalidQueryException e) {
                    invalid = true;
                }
                Assert.assertTrue((boolean)invalid);
            }
        }
    }

    @Test
    public void testIncompatibleQueries() throws Exception {
        CachingSparqlStreamProcessor engine = new CachingSparqlStreamProcessor();
        BiConsumer<BindingSet, Long> bsh = (result, expirationTime) -> {};
        for (String q : INCOMPATIBLE_QUERIES) {
            String name = "incompatible/" + q + ".rq";
            boolean incompatible = false;
            try (InputStream in = RDFStreamProcessor.class.getResourceAsStream(name);){
                String query = IOUtil.readString((InputStream)in);
                try {
                    engine.addQuery(0, query, bsh);
                }
                catch (StreamProcessor.IncompatibleQueryException e) {
                    incompatible = true;
                }
                Assert.assertTrue((boolean)incompatible);
            }
        }
    }

    @Test
    public void testSimple() throws Exception {
        this.compareAnswers(this.loadData("example.nq"), this.loadQuery("simple-sp.rq"));
    }

    @Test
    public void testSingleJoinIn() throws Exception {
        this.compareAnswers(this.loadData("example.nq"), this.loadQuery("simple-join-in.rq"));
    }

    @Test
    public void testSingleJoinOut() throws Exception {
        this.compareAnswers(this.loadData("example.nq"), this.loadQuery("simple-join-out.rq"));
    }

    @Test
    public void testUnselectedVariables() throws Exception {
        this.compareAnswers(this.loadData("example.nq"), this.loadQuery("unselected-variables.rq"));
    }

    @Test
    public void testProjection() throws Exception {
        this.compareAnswers(this.loadData("example.nq"), this.loadQuery("simple-sp-with-proj.rq"));
        this.compareAnswers(this.loadData("example.nq"), this.loadQuery("simple-join-out-with-proj.rq"));
    }

    @Test
    public void testSimultaneousQueries() throws Exception {
        this.compareAnswers(this.loadData("example.nq"), this.loadQuery("simple-join-in.rq"), this.loadQuery("simple-join-out.rq"));
    }

    @Test
    public void testMultipleJoins() throws Exception {
        this.compareAnswers(this.loadData("example.nq"), this.loadQuery("multiple-join-1.rq"));
    }

    @Test
    public void testDistinct() throws Exception {
        Collection answers = this.distinctContinuousQueryAnswers(this.loadData("example.nq"), new TupleExpr[]{this.loadQuery("exponential-join-all-nodistinct.rq")})[0];
        answers = this.distinctStaticQueryAnswers(this.loadData("example.nq"), new TupleExpr[]{this.loadQuery("exponential-join-all-nodistinct.rq")})[0];
        answers = this.continuousQueryAnswers(this.loadData("example.nq"), this.loadQuery("exponential-join-nodistinct.rq"), false);
        answers = this.continuousQueryAnswers(this.loadData("example.nq"), this.loadQuery("exponential-join-distinct.rq"), false);
        Assert.assertEquals((long)13L, (long)answers.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReduced() throws Exception {
        long overflow = SparqlStreamProcessor.getReducedModifierCapacity();
        SparqlStreamProcessor.setReducedModifierCapacity((long)2L);
        try {
            int raw = this.continuousQueryAnswers(this.loadData("example.nq"), this.loadQuery("exponential-join-nodistinct.rq"), false).size();
            int distinct = this.continuousQueryAnswers(this.loadData("example.nq"), this.loadQuery("exponential-join-distinct.rq"), false).size();
            int reduced = this.continuousQueryAnswers(this.loadData("example.nq"), this.loadQuery("exponential-join-reduced.rq"), false).size();
            Assert.assertTrue((reduced <= raw ? 1 : 0) != 0);
            Assert.assertTrue((reduced > distinct ? 1 : 0) != 0);
        }
        finally {
            SparqlStreamProcessor.setReducedModifierCapacity((long)overflow);
        }
    }

    @Test
    public void testCircleJoins() throws Exception {
        this.compareAnswers(this.loadData("simple-cycle.nq"), this.loadQuery("circle-join.rq"));
        this.compareAnswers(this.loadData("example.nq"), this.loadQuery("circle-join.rq"));
    }

    @Test
    public void testFilters() throws Exception {
        this.compareAnswers(this.loadData("example.nq"), this.loadQuery("filter-regex.rq"));
        this.compareAnswers(this.loadData("example.nq"), this.loadQuery("filter-with-projection.rq"));
        Set answers = this.distinctContinuousQueryAnswers(this.loadData("example.nq"), new TupleExpr[]{this.loadQuery("filter-equal.rq")})[0];
        Assert.assertEquals((long)6L, (long)answers.size());
        answers = this.distinctContinuousQueryAnswers(this.loadData("example.nq"), new TupleExpr[]{this.loadQuery("filter-isLiteral.rq")})[0];
        Assert.assertEquals((long)10L, (long)answers.size());
        answers = this.distinctContinuousQueryAnswers(this.loadData("example.nq"), new TupleExpr[]{this.loadQuery("filter-regex.rq")})[0];
        Assert.assertEquals((long)1L, (long)answers.size());
        Assert.assertEquals((Object)"Zaphod Beeblebrox", (Object)((BindingSet)answers.iterator().next()).getValue("name").stringValue());
        answers = this.distinctContinuousQueryAnswers(this.loadData("example.nq"), new TupleExpr[]{this.loadQuery("filter-ceil.rq")})[0];
        Assert.assertEquals((long)2L, (long)answers.size());
        Assert.assertEquals((Object)"3.1415926", (Object)((BindingSet)answers.iterator().next()).getValue("v").stringValue());
        Assert.assertEquals((Object)"3.1415926", (Object)((BindingSet)answers.iterator().next()).getValue("v").stringValue());
        answers = this.distinctContinuousQueryAnswers(this.loadData("example.nq"), new TupleExpr[]{this.loadQuery("filter-year.rq")})[0];
        Assert.assertEquals((long)1L, (long)answers.size());
        answers = this.distinctContinuousQueryAnswers(this.loadData("example.nq"), new TupleExpr[]{this.loadQuery("filter-md5.rq")})[0];
        Assert.assertEquals((long)3L, (long)answers.size());
    }

    @Test
    public void testLimitAndOffset() throws Exception {
        Collection answers = this.continuousQueryAnswers(this.loadData("example.nq"), this.loadQuery("limit.rq"), false);
        Assert.assertEquals((long)2L, (long)answers.size());
        answers = this.continuousQueryAnswers(this.loadData("example.nq"), this.loadQuery("offset.rq"), false);
        Assert.assertEquals((long)3L, (long)answers.size());
    }

    @Test
    public void testAsk() throws Exception {
        Collection answers = this.continuousQueryAnswers(this.loadData("example.nq"), this.loadQuery("ask-1.rq"), false);
        Assert.assertEquals((long)1L, (long)answers.size());
        answers = this.continuousQueryAnswers(this.loadData("example.nq"), this.loadQuery("ask-2.rq"), false);
        Assert.assertEquals((long)0L, (long)answers.size());
    }

    @Test
    public void testConstruct() throws Exception {
        Collection answers = this.continuousQueryAnswers(this.loadData("example.nq"), this.loadQuery("construct.rq"), false);
        Assert.assertTrue((answers.size() >= 5 ? 1 : 0) != 0);
        for (BindingSet b : answers) {
            junit.framework.Assert.assertNotNull((Object)b.getValue("subject"));
            Assert.assertEquals((Object)this.valueFactory.createIRI("http://xmlns.com/foaf/0.1/name"), (Object)b.getValue("predicate"));
            junit.framework.Assert.assertNotNull((Object)b.getValue("object"));
        }
    }

    @Test(expected=StreamProcessor.IncompatibleQueryException.class)
    public void testDescribe() throws Exception {
        this.continuousQueryAnswers(this.loadData("example.nq"), this.loadQuery("describe.rq"), false);
    }

    @Test
    public void testQueryTime() throws Exception {
        Collection answers;
        int i;
        long startTime = System.currentTimeMillis();
        for (i = 0; i < 1000; ++i) {
            answers = this.distinctStaticQueryAnswers(this.loadData("example.nq"), new TupleExpr[]{this.loadQuery("exponential-join-nodistinct.rq")})[0];
        }
        long endTime = System.currentTimeMillis();
        System.out.println("MemoryStore query time: " + (endTime - startTime));
        startTime = System.currentTimeMillis();
        for (i = 0; i < 1000; ++i) {
            answers = this.continuousQueryAnswers(this.loadData("example.nq"), this.loadQuery("exponential-join-nodistinct.rq"), false);
        }
        endTime = System.currentTimeMillis();
        System.out.println("SesameStream query time: " + (endTime - startTime));
    }

    @Test(expected=StreamProcessor.IncompatibleQueryException.class)
    public void testNotExistsUnsupported() throws Exception {
        this.continuousQueryAnswers(this.loadData("example.nq"), this.loadQuery("not-exists.rq"), false);
    }

    protected void compareAnswers(List<Statement> data, TupleExpr ... queries) throws Exception {
        Set[] staticResults = this.distinctStaticQueryAnswers(data, queries);
        Set[] contResults = this.distinctContinuousQueryAnswers(data, queries);
        for (int i = 0; i < queries.length; ++i) {
            Set staticR = staticResults[i];
            Set contR = contResults[i];
            for (BindingSet b : staticR) {
                Assert.assertTrue((String)("expected result not found for query " + i + ": " + b), (boolean)contR.contains(b));
            }
            for (BindingSet b : contR) {
                Assert.assertTrue((String)("unexpected result for query " + i + ": " + b), (boolean)staticR.contains(b));
            }
        }
    }
}

