/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.shj;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.fortytwo.stream.shj.Index;
import net.fortytwo.stream.shj.QueryContext;
import net.fortytwo.stream.shj.Solution;

public class SolutionIndex<V>
implements Index<Solution<V>> {
    private final int cardinality;
    private final QueryContext<?, V> queryContext;
    private final Map<Solution<V>, Solution<V>> allSolutions = new ConcurrentHashMap<Solution<V>, Solution<V>>();
    private final Map<V, Set<Solution<V>>>[] solutionsByBinding;
    private final Set<Consumer<Solution<V>>> consumers = QueryContext.newConcurrentSet();
    private final Index<Consumer<Solution<V>>> consumerIndex = new Index<Consumer<Solution<V>>>(){

        @Override
        public void add(Consumer<Solution<V>> toAdd) {
            SolutionIndex.this.consumers.add(toAdd);
        }

        @Override
        public boolean remove(Consumer<Solution<V>> toRemove) {
            return SolutionIndex.this.consumers.remove(toRemove);
        }

        @Override
        public void clear() {
            SolutionIndex.this.consumers.clear();
        }

        @Override
        public boolean isEmpty() {
            return SolutionIndex.this.consumers.isEmpty();
        }
    };

    public SolutionIndex(QueryContext<?, V> queryContext, int cardinality) {
        this.cardinality = cardinality;
        this.queryContext = queryContext;
        if (null == queryContext) {
            throw new IllegalArgumentException("null context");
        }
        if (cardinality < 1) {
            throw new IllegalArgumentException("illegal index length: " + cardinality);
        }
        this.solutionsByBinding = new Map[cardinality];
        for (int i = 0; i < cardinality; ++i) {
            this.solutionsByBinding[i] = new ConcurrentHashMap<V, Set<Solution<V>>>();
        }
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public Index<Consumer<Solution<V>>> getConsumerIndex() {
        return this.consumerIndex;
    }

    @Override
    public void add(Solution<V> solution) {
        this.addInternal(solution);
        for (Consumer<Solution<V>> s : this.consumers) {
            s.accept(solution);
        }
    }

    @Override
    public synchronized boolean remove(Solution<V> solution) {
        Solution<V> removed = this.allSolutions.remove(solution);
        if (null != removed) {
            for (int i = 0; i < this.cardinality; ++i) {
                Map<Set<Solution<V>>, Set<Solution<Set<Solution<V>>>>> solsForVariable = this.solutionsByBinding[i];
                V val = solution.getValues()[i];
                Set<Solution<V>> sols = solsForVariable.get(val);
                if (null == sols) continue;
                sols.remove(solution);
                if (!sols.isEmpty()) continue;
                solsForVariable.remove(val);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePattern(V[] pattern) {
        Set<Solution<V>> sols;
        Map<Set<Solution<V>>, Set<Solution<Set<Solution<V>>>>> byBinding;
        int minCard = Integer.MAX_VALUE;
        int bestIndex = -1;
        Object bestValue = null;
        for (int i = 0; i < this.cardinality; ++i) {
            V val = pattern[i];
            if (null == val) continue;
            byBinding = this.solutionsByBinding[i];
            sols = byBinding.get(val);
            if (null == sols) {
                return false;
            }
            int card = sols.size();
            if (card >= minCard) continue;
            bestIndex = i;
            minCard = card;
            bestValue = val;
        }
        if (-1 == bestIndex) {
            return this.removeAllInternal();
        }
        SolutionIndex solutionIndex = this;
        synchronized (solutionIndex) {
            HashSet<Solution<V>> toRemove = new HashSet<Solution<V>>();
            byBinding = this.solutionsByBinding[bestIndex];
            sols = byBinding.get(bestValue);
            for (Solution<V> s : sols) {
                boolean bl = true;
                for (int i = 0; i < this.cardinality; ++i) {
                    V val = pattern[i];
                    if (null == val || val.equals(s.getValues()[i])) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                toRemove.add(s);
            }
            boolean removed = !toRemove.isEmpty();
            for (Solution solution : toRemove) {
                sols.remove(solution);
                if (sols.isEmpty()) {
                    byBinding.remove(bestValue);
                }
                if (null == this.allSolutions.remove(solution)) continue;
                this.removeFromManager(solution);
            }
            toRemove.clear();
            return removed;
        }
    }

    @Override
    public synchronized void clear() {
        this.allSolutions.clear();
        for (Map<V, Set<Solution<V>>> set : this.solutionsByBinding) {
            set.clear();
        }
        this.consumerIndex.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.allSolutions.isEmpty();
    }

    public Set<Solution<V>> getSolutions() {
        return this.allSolutions.keySet();
    }

    public Set<Solution<V>> getSolutions(int index, V value) {
        return this.solutionsByBinding[index].get(value);
    }

    private synchronized boolean removeAllInternal() {
        boolean removed = !this.allSolutions.isEmpty();
        this.allSolutions.keySet().forEach(this::removeFromManager);
        this.allSolutions.clear();
        for (Map<V, Set<Solution<V>>> solutions : this.solutionsByBinding) {
            solutions.clear();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInternal(Solution<V> solution) {
        Solution<V> existing = this.allSolutions.get(solution);
        if (null != existing) {
            int cmp = solution.compareByExpirationTime(existing);
            if (cmp <= 0) {
                return;
            }
            this.remove(existing);
        }
        SolutionIndex solutionIndex = this;
        synchronized (solutionIndex) {
            this.allSolutions.put(solution, solution);
            for (int i = 0; i < this.cardinality; ++i) {
                Map<Set<Solution<Set<Solution<Set<Solution<V>>>>>>, Set<Solution<Set<Solution<Set<Solution<Set<Solution<V>>>>>>>>> byBinding = this.solutionsByBinding[i];
                V val = solution.getValues()[i];
                Set<Solution<Object>> sols = byBinding.get(val);
                if (null == sols) {
                    sols = QueryContext.newConcurrentSet();
                    byBinding.put((Set<Solution<Set<Solution<Set<Solution<V>>>>>>)val, (Set<Solution<Set<Solution<Set<Solution<Set<Solution<V>>>>>>>>)sols);
                }
                sols.add(solution);
            }
        }
    }

    private void removeFromManager(Solution<V> toRemove) {
        this.queryContext.getSolutionExpirationManager().remove(toRemove);
    }
}

