/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.shj;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.fortytwo.stream.model.VariableOrConstant;
import net.fortytwo.stream.shj.Expirable;
import net.fortytwo.stream.shj.GraphPattern;
import net.fortytwo.stream.shj.Index;
import net.fortytwo.stream.shj.JoinHelper;
import net.fortytwo.stream.shj.QueryContext;
import net.fortytwo.stream.shj.TuplePattern;

public class Query<K, V>
implements Expirable {
    private GraphPattern<K, V> graphPattern;
    private BiConsumer<Map<K, V>, Long> solutionHandler;
    private final long expirationTime;
    private final Index<Query<K, V>> expirationIndex;
    private List<JoinHelper<K, V>> allHelpers;

    public Query(GraphPattern<K, V> graphPattern, long expirationTime, Index<Query<K, V>> expirationIndex, BiConsumer<Map<K, V>, Long> solutionHandler) {
        this.graphPattern = graphPattern;
        this.expirationTime = expirationTime;
        this.expirationIndex = expirationIndex;
        this.solutionHandler = solutionHandler;
        this.checkValid();
    }

    public GraphPattern<K, V> getGraphPattern() {
        return this.graphPattern;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public void expire() {
        this.expirationIndex.remove(this);
        this.graphPattern = null;
        this.solutionHandler = null;
    }

    @Override
    public boolean isExpired() {
        return null == this.graphPattern;
    }

    public List<JoinHelper<K, V>> getAllHelpers() {
        return this.allHelpers;
    }

    public void setAllHelpers(List<JoinHelper<K, V>> allHelpers) {
        if (null != this.allHelpers) {
            throw new IllegalStateException();
        }
        this.allHelpers = allHelpers;
        HashMap helpersByVariable = new HashMap();
        for (JoinHelper<K, V> wrapper : allHelpers) {
            for (K key : wrapper.getKeys()) {
                Set set = (Set)helpersByVariable.get(key);
                if (null == set) {
                    set = QueryContext.newConcurrentSet();
                    helpersByVariable.put(key, set);
                }
                set.add(wrapper);
            }
        }
        for (JoinHelper<K, V> helper : allHelpers) {
            helper.initialize(allHelpers, helpersByVariable, this.solutionHandler);
        }
    }

    private void checkValid() {
        int i = 0;
        for (TuplePattern<K, V> pattern : this.graphPattern.getPatterns()) {
            boolean hasVariables = false;
            for (VariableOrConstant<K, V> vc : pattern.getPattern()) {
                if (null == vc.getVariable()) continue;
                hasVariables = true;
                break;
            }
            if (!hasVariables) {
                throw new IllegalArgumentException("tuple pattern " + i + " has no variables");
            }
            ++i;
        }
    }
}

