/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.shj;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fortytwo.stream.shj.Solution;
import net.fortytwo.stream.shj.SolutionIndex;

public class JoinHelper<K, V>
implements Consumer<Solution<V>> {
    private final SolutionIndex<V> solutionIndex;
    private final K[] keys;
    private final Map<K, Integer> indexByKey;
    private List<JoinHelper<K, V>> allHelpers;
    private Map<K, Set<JoinHelper<K, V>>> helpersByVariable;
    private BiConsumer<Map<K, V>, Long> solutionConsumer;

    public JoinHelper(SolutionIndex<V> solutionIndex, Map<K, Integer> indexByKey) {
        this.solutionIndex = solutionIndex;
        this.indexByKey = indexByKey;
        this.keys = new Object[indexByKey.size()];
        for (Map.Entry<K, Integer> e : indexByKey.entrySet()) {
            this.keys[e.getValue().intValue()] = e.getKey();
        }
    }

    public Set<Solution<V>> getSolutions() {
        return this.solutionIndex.getSolutions();
    }

    public Set<Solution<V>> getSolutions(K key, V val) {
        Integer index = this.indexByKey.get(key);
        return null == index ? null : this.solutionIndex.getSolutions(index, val);
    }

    public K[] getKeys() {
        return this.keys;
    }

    public void initialize(List<JoinHelper<K, V>> allHelpers, Map<K, Set<JoinHelper<K, V>>> helpersByVariable, BiConsumer<Map<K, V>, Long> solutionConsumer) {
        this.allHelpers = allHelpers;
        this.helpersByVariable = helpersByVariable;
        this.solutionConsumer = solutionConsumer;
    }

    @Override
    public void accept(Solution<V> solution) {
        HashSet<JoinHelper<K, V>> remaining = new HashSet<JoinHelper<K, V>>();
        remaining.addAll(this.allHelpers);
        LinkedList<Solution<V>> solutions = new LinkedList<Solution<V>>();
        solutions.add(solution);
        K newBoundKey = this.keys[0];
        ArrayList<Map<K, V>> tmpMaps = new ArrayList<Map<K, V>>();
        HashMap<K, V> mapping = new HashMap<K, V>();
        V[] values = solution.getValues();
        for (int i = 0; i < this.keys.length; ++i) {
            mapping.put(this.keys[i], values[i]);
        }
        this.hashJoin(solutions, remaining, newBoundKey, tmpMaps, mapping, 0, false, solution.getExpirationTime());
    }

    private void hashJoin(Collection<Solution<V>> solutions, Set<JoinHelper<K, V>> remaining, K newBoundKey, List<Map<K, V>> maps, Map<K, V> curMapping, int depth, boolean checkCompatible, long expirationTime) {
        Map<K, V> nextMapping;
        remaining.remove(this);
        if (checkCompatible) {
            if (depth < maps.size()) {
                nextMapping = maps.get(depth);
                nextMapping.clear();
            } else {
                nextMapping = new HashMap();
                nextMapping.putAll(curMapping);
            }
        } else {
            nextMapping = curMapping;
        }
        for (Solution<V> solution : solutions) {
            this.trySolution(solution, remaining, newBoundKey, maps, curMapping, nextMapping, depth + 1, checkCompatible, expirationTime);
        }
        remaining.add(this);
    }

    private long minExpirationTime(long time1, long time2) {
        return Math.min(time1, time2);
    }

    private void trySolution(Solution<V> solution, Set<JoinHelper<K, V>> remaining, K newBoundKey, List<Map<K, V>> maps, Map<K, V> curMapping, Map<K, V> nextMapping, int depth, boolean checkCompatible, long expirationTime) {
        V[] values = solution.getValues();
        if (checkCompatible && this.keys.length > 1) {
            boolean compatible = true;
            for (int i = 0; i < this.keys.length; ++i) {
                K key = this.keys[i];
                if (key.equals(newBoundKey)) continue;
                V val = values[i];
                Iterator<Map.Entry<K, V>> boundVal = curMapping.get(key);
                if (null != boundVal && !boundVal.equals(val)) {
                    compatible = false;
                    break;
                }
                nextMapping.put(key, val);
            }
            if (!compatible) {
                return;
            }
        }
        if (remaining.isEmpty()) {
            HashMap<K, V> copy = new HashMap<K, V>(nextMapping);
            long newExpirationTime = this.minExpirationTime(expirationTime, solution.getExpirationTime());
            this.solutionConsumer.accept(copy, newExpirationTime);
        } else {
            JoinHelper<K, V> bestHelper = null;
            K bestKey = null;
            Set<Solution<V>> bestSet = null;
            int minSize = Integer.MAX_VALUE;
            for (Map.Entry<K, V> e : nextMapping.entrySet()) {
                K key = e.getKey();
                V val = e.getValue();
                for (JoinHelper<K, V> helper : this.helpersByVariable.get(key)) {
                    if (!remaining.contains(helper)) continue;
                    Set<Solution<V>> sols = helper.getSolutions(key, val);
                    if (null == sols) {
                        return;
                    }
                    int size = sols.size();
                    if (size >= minSize) continue;
                    bestHelper = helper;
                    bestKey = key;
                    bestSet = sols;
                    minSize = size;
                }
            }
            if (null != bestHelper) {
                long newExpirationTime = this.minExpirationTime(expirationTime, solution.getExpirationTime());
                super.hashJoin(bestSet, remaining, bestKey, maps, nextMapping, depth, true, newExpirationTime);
            }
        }
    }
}

