/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.shj;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.fortytwo.stream.model.DirectedGraph;
import net.fortytwo.stream.model.SimpleDirectedGraph;
import net.fortytwo.stream.model.VariableOrConstant;
import net.fortytwo.stream.shj.TuplePattern;

public class GraphPattern<K, V> {
    private final TuplePattern<K, V>[] patterns;

    public GraphPattern(TuplePattern<K, V> ... patterns) {
        if (0 == patterns.length) {
            throw new IllegalArgumentException("the empty graph pattern is not supported");
        }
        this.patterns = patterns;
    }

    public TuplePattern<K, V>[] getPatterns() {
        return this.patterns;
    }

    public boolean isFullyConnected() {
        final HashMap<K, HashSet<TuplePattern<K, V>>> patternByVariable = new HashMap<K, HashSet<TuplePattern<K, V>>>();
        final HashMap variableByPattern = new HashMap();
        for (TuplePattern<K, V> p : this.patterns) {
            HashSet<K> vars = new HashSet<K>();
            variableByPattern.put(p, vars);
            for (VariableOrConstant<K, V> vc : p.getPattern()) {
                K var = vc.getVariable();
                if (null == var) continue;
                vars.add(var);
                HashSet<TuplePattern<K, V>> set = (HashSet<TuplePattern<K, V>>)patternByVariable.get(var);
                if (null == set) {
                    set = new HashSet<TuplePattern<K, V>>();
                    patternByVariable.put(var, set);
                }
                set.add(p);
            }
        }
        SimpleDirectedGraph graph = new SimpleDirectedGraph(new DirectedGraph<TuplePattern<K, V>>(){

            @Override
            public void forVertices(Consumer<TuplePattern<K, V>> visitor) {
                for (TuplePattern vertex : GraphPattern.this.patterns) {
                    visitor.accept(vertex);
                }
            }

            @Override
            public void forOutEdges(TuplePattern<K, V> tail, Consumer<TuplePattern<K, V>> headVisitor) {
                for (Object key : (Set)variableByPattern.get(tail)) {
                    Set heads = (Set)patternByVariable.get(key);
                    if (null == heads) continue;
                    heads.stream().filter(head -> head != tail).forEach(headVisitor::accept);
                }
            }
        });
        return graph.isFullyConnected();
    }
}

