/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.shj;

import java.util.AbstractQueue;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fortytwo.stream.shj.Expirable;
import net.fortytwo.stream.shj.Index;

public abstract class ExpirationManager<T extends Expirable>
implements Index<T> {
    private static final Logger logger = Logger.getLogger(ExpirationManager.class.getName());
    private boolean stopped = true;
    private boolean verbose = false;
    private final Object waitLock = "";
    private final AbstractQueue<T> heap = new PriorityQueue<T>(new Comparator<T>(){

        @Override
        public int compare(T o1, T o2) {
            long t1 = o1.getExpirationTime();
            long t2 = o2.getExpirationTime();
            return Long.valueOf(t1).compareTo(t2);
        }
    });

    protected abstract long getNow();

    @Override
    public boolean isEmpty() {
        this.evictExpired();
        return this.heap.isEmpty();
    }

    @Override
    public void clear() {
        this.heap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(T toAdd) {
        if (this.isFinite(toAdd)) {
            ExpirationManager expirationManager = this;
            synchronized (expirationManager) {
                this.heap.add(toAdd);
            }
        }
    }

    @Override
    public boolean remove(T toRemove) {
        if (this.isFinite(toRemove)) {
            toRemove.expire();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFinishedAdding() {
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.notify();
        }
    }

    private long getClockTime() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int evictExpired() {
        long startTime = 0L;
        int startSize = 0;
        long now = this.getNow();
        if (this.verbose) {
            startSize = this.getHeapSize();
            startTime = this.getClockTime();
        }
        int count = 0;
        try {
            while (!this.heap.isEmpty()) {
                Expirable first = (Expirable)this.heap.peek();
                if (first.isExpired()) {
                    this.heap.poll();
                    continue;
                }
                if (first.getExpirationTime() > now) {
                    int n = count;
                    return n;
                }
                ((Expirable)this.heap.poll()).expire();
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            if (this.verbose && count > 0) {
                long after = this.getClockTime();
                logger.info("evicted " + count + " of " + startSize + " items in " + (after - startTime) + " ms");
            }
        }
    }

    private boolean isFinite(T toCheck) {
        return toCheck.getExpirationTime() != Long.MAX_VALUE;
    }

    public synchronized void start() {
        if (!this.stopped) {
            return;
        }
        this.stopped = false;
        new Thread(() -> {
            try {
                logger.info(ExpirationManager.class.getSimpleName() + " thread started");
                while (!this.stopped) {
                    long firstExpiringTimestamp = this.heap.isEmpty() ? 0L : ((Expirable)this.heap.peek()).getExpirationTime();
                    try {
                        Object object = this.waitLock;
                        synchronized (object) {
                            if (0L == firstExpiringTimestamp) {
                                this.waitLock.wait();
                            } else {
                                long now = this.getNow();
                                if (now < firstExpiringTimestamp) {
                                    this.waitLock.wait(firstExpiringTimestamp - now);
                                }
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        logger.warning(ExpirationManager.class.getSimpleName() + " thread interrupted while waiting");
                    }
                    this.evictExpired();
                }
                logger.info(ExpirationManager.class.getSimpleName() + " thread stopped");
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, ExpirationManager.class.getSimpleName() + " thread died with error", e);
            }
        }).start();
    }

    public synchronized void stop() {
        this.stopped = true;
    }

    public int getHeapSize() {
        return this.heap.size();
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

