/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.fortytwo.stream.model.DirectedGraph;

public class SimpleDirectedGraph<T>
implements DirectedGraph<T> {
    private final Set<T> vertices = new HashSet<T>();
    private final Map<T, Set<T>> edges = new HashMap<T, Set<T>>();

    public SimpleDirectedGraph() {
    }

    public SimpleDirectedGraph(final DirectedGraph<T> other) {
        other.forVertices(new Consumer<T>(){

            @Override
            public void accept(T vertex) {
                SimpleDirectedGraph.this.vertices.add(vertex);
                other.forOutEdges(vertex, head -> SimpleDirectedGraph.this.addEdge(vertex, head));
            }
        });
    }

    public void addEdge(T tail, T head) {
        this.vertices.add(tail);
        this.vertices.add(head);
        Set<T> inc = this.edges.get(tail);
        if (null == inc) {
            inc = new HashSet<T>();
            this.edges.put(tail, inc);
        }
        inc.add(head);
    }

    @Override
    public void forVertices(Consumer<T> visitor) {
        this.vertices.forEach(visitor::accept);
    }

    @Override
    public void forOutEdges(T tail, Consumer<T> headVisitor) {
        Set<Object> inc = this.edges.get(tail);
        if (null == inc) {
            throw new IllegalArgumentException();
        }
        inc.forEach(headVisitor::accept);
    }

    public boolean isFullyConnected() {
        int before;
        if (0 == this.edges.size()) {
            return 1 == this.vertices.size();
        }
        if (1 == this.edges.size() && 1 == this.vertices.size()) {
            return true;
        }
        HashSet<T> tails = new HashSet<T>();
        tails.add(this.edges.keySet().iterator().next());
        do {
            before = tails.size();
            LinkedList<T> buffer = new LinkedList<T>();
            buffer.addAll(tails);
            for (Object tail : buffer) {
                Set<T> heads = this.edges.get(tail);
                if (null == heads) continue;
                tails.addAll(heads);
            }
        } while (tails.size() != before);
        return tails.size() == this.vertices.size();
    }
}

