/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.caching;

public class SolutionPattern {
    protected int remainingPatterns;
    protected int matchedPatterns;
    protected long expirationTime;

    protected SolutionPattern(int remainingPatterns, int matchedPatterns, long expirationTime) {
        this.remainingPatterns = remainingPatterns;
        this.matchedPatterns = matchedPatterns;
        this.expirationTime = expirationTime;
    }

    public SolutionPattern(SolutionPattern other) {
        this.copyFrom(other);
    }

    public void copyFrom(SolutionPattern other) {
        this.remainingPatterns = other.remainingPatterns;
        this.matchedPatterns = other.matchedPatterns;
        this.expirationTime = other.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public boolean isExpired(long now) {
        return this.expirationTime > 0L && this.expirationTime < now;
    }

    public boolean isComplete() {
        return 0 == this.remainingPatterns;
    }

    public boolean disjointWith(SolutionPattern other) {
        return 0 == (this.matchedPatterns & other.matchedPatterns);
    }

    public ContainmentRelation relateTo(SolutionPattern other) {
        int x = this.matchedPatterns ^ other.matchedPatterns;
        if (0 == x) {
            return this.matchedPatterns == other.matchedPatterns ? ContainmentRelation.Equal : ContainmentRelation.Disjoint;
        }
        return 0 == (this.matchedPatterns & x) ? ContainmentRelation.ContainedIn : (0 == (other.matchedPatterns & x) ? ContainmentRelation.Contains : ContainmentRelation.PartialIntersect);
    }

    public static long minExpirationTime(SolutionPattern s1, SolutionPattern s2) {
        return 0L == s1.expirationTime ? (0L == s2.expirationTime ? 0L : s2.expirationTime) : (0L == s2.expirationTime ? s1.expirationTime : Math.min(s1.expirationTime, s2.expirationTime));
    }

    public static int compareExpirationTimes(SolutionPattern s1, SolutionPattern s2) {
        return 0L == s1.expirationTime ? (0L == s2.expirationTime ? 0 : 1) : (0L == s2.expirationTime ? -1 : Long.valueOf(s1.expirationTime).compareTo(s2.expirationTime));
    }

    public static enum ContainmentRelation {
        Contains,
        ContainedIn,
        Equal,
        PartialIntersect,
        Disjoint;

    }
}

