/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.caching;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import net.fortytwo.stream.caching.Bindings;
import net.fortytwo.stream.caching.Query;
import net.fortytwo.stream.caching.Solution;
import net.fortytwo.stream.caching.SolutionGroup;
import net.fortytwo.stream.caching.SolutionPattern;
import net.fortytwo.stream.model.LList;

public class SolutionIndex<T> {
    private final Query.QueryVariables queryVariables;
    private final int totalPatterns;
    private final Map<String, Map<T, Set<SolutionGroup<T>>>> groupsByBinding = new HashMap<String, Map<T, Set<SolutionGroup<T>>>>();
    private final Map<Integer, SolutionGroup<T>> groupsByHash = new HashMap<Integer, SolutionGroup<T>>();

    public SolutionIndex(Query.QueryVariables queryVariables, int totalPatterns) {
        this.queryVariables = queryVariables;
        this.totalPatterns = totalPatterns;
    }

    public synchronized boolean add(Solution<T> s, long now) {
        Bindings<T> b = s.getBindings();
        int hash = b.getHash();
        SolutionGroup<T> g = this.groupsByHash.get(hash);
        if (null == g) {
            g = new SolutionGroup<T>(b);
            this.groupsByHash.put(hash, g);
            for (Map.Entry<String, T> e : b.entrySet()) {
                Set<SolutionGroup<T>> groups;
                Map<T, Set<SolutionGroup<T>>> groupsByValue = this.groupsByBinding.get(e.getKey());
                if (null == groupsByValue) {
                    groupsByValue = new HashMap<T, Set<SolutionGroup<T>>>();
                    this.groupsByBinding.put(e.getKey(), groupsByValue);
                }
                if (null == (groups = groupsByValue.get(e.getValue()))) {
                    groups = this.newSolutionGroupSet();
                    groupsByValue.put(e.getValue(), groups);
                }
                groups.add(g);
            }
        }
        return g.add(s, now);
    }

    public Iterator<Solution<T>> getSolutions(String variable, T value, long now) {
        Set<SolutionGroup<T>> groups = this.getSolutionGroups(variable, value);
        return null == groups ? null : new SolutionIterator<T>(groups.iterator(), now);
    }

    public Iterator<Solution<T>> getComposableSolutions(String variable, T value, final Solution<T> ps, long now) {
        Iterator<Solution<T>> iter = this.getSolutions(variable, value, now);
        return null == iter ? null : new FilteredIterator<Solution<T>, Solution<T>>(iter){

            @Override
            protected Solution<T> test(Solution<T> element) {
                return ps.composableWith(element, SolutionIndex.this.queryVariables) ? ps : null;
            }
        };
    }

    public Iterator<Solution<T>> composeSolutions(String variable, T value, final Solution<T> ps, long now) {
        Iterator<Solution<T>> iter = this.getSolutions(variable, value, now);
        return null == iter ? null : new FilteredIterator<Solution<T>, Solution<T>>(iter){

            @Override
            protected Solution<T> test(Solution<T> element) {
                return ps.composableWith(element, SolutionIndex.this.queryVariables) ? new Solution(SolutionIndex.this.totalPatterns, ps, element) : null;
            }
        };
    }

    public void joinSolutions(Solution<T> matchedSolution, Bindings<T> bindings, Stack<Solution<T>> solutions, long now) {
        solutions.clear();
        Stack helper = new Stack();
        solutions.push(matchedSolution);
        for (Map.Entry<String, T> e : bindings.entrySet()) {
            T value;
            String var = e.getKey();
            Iterator<Solution<T>> retrieved = this.getSolutions(var, value = e.getValue(), now);
            if (null == retrieved || !retrieved.hasNext()) continue;
            while (retrieved.hasNext()) {
                Solution<T> retrievedSolution = retrieved.next();
                solutions.stream().filter(s -> retrievedSolution.composableWith((Solution<T>)s, this.queryVariables)).forEach(s -> helper.push(new Solution(this.totalPatterns, retrievedSolution, s)));
            }
            while (!helper.isEmpty()) {
                solutions.push((Solution<T>)helper.pop());
            }
        }
    }

    public synchronized int removeExpired(long now) {
        int count = 0;
        LinkedList<SolutionGroup<T>> toRemove = new LinkedList<SolutionGroup<T>>();
        for (SolutionGroup<T> solutionGroup : this.groupsByHash.values()) {
            count += solutionGroup.removeExpired(now);
            if (!solutionGroup.getSolutions().isNil()) continue;
            toRemove.add(solutionGroup);
        }
        for (SolutionGroup<Object> solutionGroup : toRemove) {
            this.groupsByHash.remove(solutionGroup.getBindings().getHash());
            for (Map.Entry<String, Object> e : solutionGroup.getBindings().entrySet()) {
                Set<SolutionGroup<T>> groups;
                Map<T, Set<SolutionGroup<T>>> groupsByValue = this.groupsByBinding.get(e.getKey());
                if (null == groupsByValue || null == (groups = groupsByValue.get(e.getValue()))) continue;
                groups.remove(solutionGroup);
                if (0 == groups.size()) {
                    groupsByValue.remove(e.getValue());
                }
                if (0 != groupsByValue.size()) continue;
                this.groupsByBinding.remove(e.getKey());
            }
        }
        return count;
    }

    private Set<SolutionGroup<T>> getSolutionGroups(String variable, T value) {
        Map<T, Set<SolutionGroup<T>>> groupsByValue = this.groupsByBinding.get(variable);
        if (null == groupsByValue) {
            return null;
        }
        return groupsByValue.get(value);
    }

    private Set<SolutionGroup<T>> newSolutionGroupSet() {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return Collections.newSetFromMap(map);
    }

    private static abstract class FilteredIterator<S, T>
    implements Iterator<T> {
        private final Iterator<S> baseIterator;
        private T currentValue;

        protected FilteredIterator(Iterator<S> baseIterator) {
            this.baseIterator = baseIterator;
            this.advance();
        }

        protected abstract T test(S var1);

        @Override
        public boolean hasNext() {
            return null != this.currentValue;
        }

        @Override
        public T next() {
            T lastValue = this.currentValue;
            this.advance();
            return lastValue;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            while (this.baseIterator.hasNext()) {
                S fromValue = this.baseIterator.next();
                T toValue = this.test(fromValue);
                if (null == toValue) continue;
                this.currentValue = toValue;
                return;
            }
            this.currentValue = null;
        }
    }

    private static class SolutionIterator<T>
    implements Iterator<Solution<T>> {
        private final Solution<T> solution = new Solution(0, 0, null, 0L);
        private final Iterator<SolutionGroup<T>> groupIterator;
        private SolutionGroup<T> currentGroup;
        private LList<SolutionPattern> currentSolutions;
        private boolean advanced;
        private final long now;

        public SolutionIterator(Iterator<SolutionGroup<T>> groupIterator, long now) {
            this.groupIterator = groupIterator;
            this.now = now;
        }

        @Override
        public boolean hasNext() {
            if (!this.advanced) {
                this.advance();
            }
            return !this.currentSolutions.isNil();
        }

        @Override
        public Solution<T> next() {
            if (!this.advanced) {
                throw new IllegalStateException();
            }
            this.advanced = false;
            this.solution.copyFrom(this.currentSolutions.getValue());
            return this.solution;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            if (null != this.currentSolutions) {
                this.setCurrentSolutions(this.getRest(this.currentSolutions));
            }
            while ((null == this.currentSolutions || this.currentSolutions.isNil()) && this.groupIterator.hasNext()) {
                this.currentGroup = this.groupIterator.next();
                this.setCurrentSolutions(this.currentGroup.getSolutions());
                this.solution.setBindings(this.currentGroup.getBindings());
            }
            this.advanced = true;
        }

        private void setCurrentSolutions(LList<SolutionPattern> sols) {
            this.currentSolutions = sols;
            while (!this.currentSolutions.isNil() && this.currentSolutions.getValue().isExpired(this.now)) {
                this.currentSolutions = this.getRest(this.currentSolutions);
            }
        }

        private LList<SolutionPattern> getRest(LList<SolutionPattern> sols) {
            LList<SolutionPattern> rest = sols.getRest();
            if (null == rest) {
                rest = this.currentGroup.getSolutions();
            }
            return rest;
        }
    }
}

