/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.caching;

import net.fortytwo.stream.caching.Bindings;
import net.fortytwo.stream.caching.Query;
import net.fortytwo.stream.caching.SolutionPattern;

public class Solution<T>
extends SolutionPattern {
    private Bindings<T> bindings;

    public Solution(Solution<T> other) {
        super(other.remainingPatterns, other.matchedPatterns, other.expirationTime);
        this.bindings = other.bindings;
    }

    public Solution(int totalPatterns, int index, Bindings<T> bindings, long expirationTime) {
        super(totalPatterns - 1, 1 << index, expirationTime);
        this.bindings = bindings;
    }

    public Solution(Solution<T> other, int index) {
        super(other.remainingPatterns - 1, other.matchedPatterns | 1 << index, other.expirationTime);
        this.bindings = other.bindings;
    }

    public Solution(Solution<T> other, int index, Bindings<T> newBindings) {
        super(other.remainingPatterns - 1, other.matchedPatterns | 1 << index, other.expirationTime);
        this.bindings = Bindings.from(other.bindings, newBindings);
    }

    public Solution(int totalPatterns, Solution<T> first, Solution<T> second) {
        super(first.remainingPatterns + second.remainingPatterns - totalPatterns, first.matchedPatterns | second.matchedPatterns, Solution.minExpirationTime(first, second));
        this.bindings = Bindings.from(first.bindings, second.bindings);
    }

    public Bindings<T> getBindings() {
        return this.bindings;
    }

    public void setBindings(Bindings<T> bindings) {
        this.bindings = bindings;
    }

    public boolean composableWith(Solution<T> other, Query.QueryVariables vars) {
        return this.disjointWith(other) && this.bindings.compatibleWith(other.bindings, vars);
    }
}

