/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.shj;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fortytwo.stream.shj.SHJTestBase;
import net.fortytwo.stream.shj.Solution;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SolutionTest
extends SHJTestBase {
    private static final Logger logger = Logger.getLogger(SolutionTest.class.getName());

    @Override
    @Before
    public void setUp() {
        this.setGlobalLogLevel(Level.FINE);
        super.setUp();
    }

    private void setGlobalLogLevel(Level level) {
        for (Logger log = logger; null != log; log = log.getParent()) {
            log.setLevel(level);
            for (Handler h : log.getHandlers()) {
                h.setLevel(level);
            }
        }
    }

    @Test
    public void testSolutionSets() {
        long expTime = Long.MAX_VALUE;
        Solution<String> s1 = this.newSolution(new String[0], expTime);
        Solution<String> s2 = this.newSolution(new String[0], expTime);
        Assert.assertTrue((boolean)s1.equals(s1));
        Assert.assertTrue((boolean)s1.equals(s2));
        s2 = this.newSolution(new String[]{"v1"}, expTime);
        Assert.assertTrue((boolean)s2.equals(s2));
        Assert.assertFalse((boolean)s1.equals(s2));
        s1 = this.newSolution(new String[]{"v2"}, expTime);
        Assert.assertFalse((boolean)s1.equals(s2));
        s1 = this.newSolution(new String[]{"v1", "v2"}, expTime);
        Assert.assertFalse((boolean)s1.equals(s2));
        s2 = this.newSolution(new String[]{"v1", "v2"}, expTime);
        Assert.assertTrue((boolean)s1.equals(s2));
        s2 = this.newSolution(new String[]{"v1", "v3"}, expTime);
        Assert.assertFalse((boolean)s1.equals(s2));
    }
}

