/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.shj;

import java.util.List;
import net.fortytwo.stream.shj.JoinHelper;
import net.fortytwo.stream.shj.Query;
import net.fortytwo.stream.shj.SHJTestBase;
import org.junit.Assert;
import org.junit.Test;

public class QueryIndexTest
extends SHJTestBase {
    @Test
    public void testRemoveQuery() {
        Assert.assertTrue((boolean)this.queryIndex.isEmpty());
        Query<String, String> query1 = this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "knows", "?y"), this.tuplePattern("?y", "likes", "Everything")));
        Query<String, String> query2 = this.addQuery("query2", this.graphPattern(this.tuplePattern("?x", "knows", "?y")));
        Query<String, String> query3 = this.addQuery("query3", this.graphPattern(this.tuplePattern("?a", "knows", "?b")));
        Query<String, String> query4 = this.addQuery("query4", this.graphPattern(this.tuplePattern("?z", "likes", "?z")));
        Assert.assertFalse((boolean)this.queryIndex.isEmpty());
        Assert.assertTrue((boolean)this.queryIndex.remove(query2));
        Assert.assertFalse((boolean)this.queryIndex.isEmpty());
        Assert.assertTrue((boolean)this.queryIndex.remove(query3));
        Assert.assertFalse((boolean)this.queryIndex.isEmpty());
        Assert.assertTrue((boolean)this.queryIndex.remove(query1));
        Assert.assertFalse((boolean)this.queryIndex.isEmpty());
        Assert.assertTrue((boolean)this.queryIndex.remove(query4));
        Assert.assertTrue((boolean)this.queryIndex.isEmpty());
        Assert.assertFalse((boolean)this.queryIndex.remove(query2));
        Assert.assertTrue((boolean)this.queryIndex.isEmpty());
    }

    @Test
    public void testRemoveTuples() {
        Assert.assertTrue((boolean)this.queryIndex.isEmpty());
        List consumers1 = this.addQuery("query1", this.graphPattern(this.tuplePattern("?x", "knows", "?y"), this.tuplePattern("?y", "likes", "Everything"))).getAllHelpers();
        JoinHelper consumer1a = (JoinHelper)consumers1.get(0);
        JoinHelper consumer1b = (JoinHelper)consumers1.get(1);
        List consumers2 = this.addQuery("query2", this.graphPattern(this.tuplePattern("?a", "knows", "?b"))).getAllHelpers();
        JoinHelper consumer2a = (JoinHelper)consumers2.get(0);
        Assert.assertFalse((boolean)this.queryIndex.isEmpty());
        Assert.assertEquals((long)0L, (long)consumer1a.getSolutions().size());
        Assert.assertEquals((long)0L, (long)consumer1b.getSolutions().size());
        Assert.assertEquals((long)0L, (long)consumer2a.getSolutions().size());
        Assert.assertFalse((boolean)this.queryIndex.remove((Object[])this.tuple("Arthur", "knows", "Ford")));
        this.queryIndex.add((Object[])this.tuple("Arthur", "knows", "Ford"), Long.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)consumer1a.getSolutions().size());
        Assert.assertEquals((long)0L, (long)consumer1b.getSolutions().size());
        Assert.assertEquals((long)1L, (long)consumer2a.getSolutions().size());
        this.expectQuerySolutions("query1", 0);
        this.expectQuerySolutions("query2", 1);
        Assert.assertFalse((boolean)this.queryIndex.remove((Object[])this.tuple("Arthur", "knows", "Zaphod")));
        Assert.assertFalse((boolean)this.queryIndex.remove((Object[])this.tuple("Ford", "likes", "Everything")));
        Assert.assertFalse((boolean)this.queryIndex.remove((Object[])this.tuple("Arthur", "hasFriend", "Ford")));
        Assert.assertEquals((long)1L, (long)consumer1a.getSolutions().size());
        Assert.assertEquals((long)0L, (long)consumer1b.getSolutions().size());
        Assert.assertEquals((long)1L, (long)consumer2a.getSolutions().size());
        Assert.assertTrue((boolean)this.queryIndex.remove((Object[])this.tuple("Arthur", "knows", "Ford")));
        Assert.assertEquals((long)0L, (long)consumer1a.getSolutions().size());
        Assert.assertEquals((long)0L, (long)consumer1b.getSolutions().size());
        Assert.assertEquals((long)0L, (long)consumer2a.getSolutions().size());
        Assert.assertFalse((boolean)this.queryIndex.remove((Object[])this.tuple("Arthur", "knows", "Ford", "g1")));
        this.queryIndex.add((Object[])this.tuple("Arthur", "knows", "Ford"), Long.MAX_VALUE);
        this.expectQuerySolutions("query1", 0);
        this.expectQuerySolutions("query2", 1);
        Assert.assertTrue((boolean)this.queryIndex.remove((Object[])this.tuple("Arthur", "knows", "Ford", "g1")));
    }
}

