/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.shj;

import net.fortytwo.stream.shj.GraphPattern;
import net.fortytwo.stream.shj.SHJTestBase;
import net.fortytwo.stream.shj.TuplePattern;
import org.junit.Assert;
import org.junit.Test;

public class GraphPatternTest
extends SHJTestBase {
    @Test(expected=IllegalArgumentException.class)
    public void testEmptyTuplePatternArrayIsRejected() {
        new GraphPattern(new TuplePattern[0]);
    }

    @Test
    public void testTuplePatternsWithDifferingLengthsAreAccepted() {
        GraphPattern pattern = new GraphPattern(new TuplePattern[]{this.tuplePattern("?x", "knows", "?y"), this.tuplePattern("?x", "age", "21", "2016graph")});
        Assert.assertEquals((long)2L, (long)pattern.getPatterns().length);
    }

    @Test
    public void testTuplePatternsAreOrdered() {
        GraphPattern pattern = new GraphPattern(new TuplePattern[]{this.tuplePattern("?x", "knows", "?y"), this.tuplePattern("?x", "age", "21")});
        Assert.assertEquals((long)2L, (long)pattern.getPatterns().length);
        Assert.assertEquals((long)3L, (long)pattern.getPatterns()[0].getPattern().length);
        Assert.assertEquals((long)3L, (long)pattern.getPatterns()[1].getPattern().length);
        Assert.assertEquals((Object)"?x", (Object)pattern.getPatterns()[0].getPattern()[0].getVariable());
        Assert.assertNull((Object)pattern.getPatterns()[0].getPattern()[0].getConstant());
        Assert.assertNull((Object)pattern.getPatterns()[0].getPattern()[1].getVariable());
        Assert.assertEquals((Object)"knows", (Object)pattern.getPatterns()[0].getPattern()[1].getConstant());
        Assert.assertEquals((Object)"?y", (Object)pattern.getPatterns()[0].getPattern()[2].getVariable());
        Assert.assertNull((Object)pattern.getPatterns()[0].getPattern()[2].getConstant());
        Assert.assertEquals((Object)"?x", (Object)pattern.getPatterns()[1].getPattern()[0].getVariable());
        Assert.assertNull((Object)pattern.getPatterns()[1].getPattern()[0].getConstant());
        Assert.assertNull((Object)pattern.getPatterns()[1].getPattern()[1].getVariable());
        Assert.assertEquals((Object)"age", (Object)pattern.getPatterns()[1].getPattern()[1].getConstant());
        Assert.assertNull((Object)pattern.getPatterns()[1].getPattern()[2].getVariable());
        Assert.assertEquals((Object)"21", (Object)pattern.getPatterns()[1].getPattern()[2].getConstant());
    }

    @Test
    public void testIsFullyConnected() {
        GraphPattern<String, String> pattern = this.graphPattern(this.tuplePattern("?x", "knows", "?y"));
        Assert.assertTrue((boolean)pattern.isFullyConnected());
        pattern = this.graphPattern(this.tuplePattern("?x", "knows", "?y"), this.tuplePattern("?y", "knows", "Arthur"));
        Assert.assertTrue((boolean)pattern.isFullyConnected());
        pattern = this.graphPattern(this.tuplePattern("Ford", "knows", "Arthur"));
        Assert.assertTrue((boolean)pattern.isFullyConnected());
        pattern = this.graphPattern(this.tuplePattern("Ford", "knows", "Arthur"), this.tuplePattern("Arthur", "knows", "Trillian"));
        Assert.assertFalse((boolean)pattern.isFullyConnected());
        pattern = this.graphPattern(this.tuplePattern("Ford", "knows", "Arthur"), this.tuplePattern("?x", "knows", "Arthur"));
        Assert.assertFalse((boolean)pattern.isFullyConnected());
        pattern = this.graphPattern(this.tuplePattern("?x", "knows", "?y"), this.tuplePattern("?y", "knows", "Arthur"), this.tuplePattern("?z", "likes", "Beer"));
        Assert.assertFalse((boolean)pattern.isFullyConnected());
    }
}

