/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.stream.caching;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import net.fortytwo.stream.caching.Bindings;
import net.fortytwo.stream.caching.Query;
import net.fortytwo.stream.caching.Solution;
import net.fortytwo.stream.caching.SolutionIndex;
import net.fortytwo.stream.model.VariableOrConstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SolutionIndexTest {
    private long now;
    private final long exp = 0L;
    private Query.QueryVariables vars;
    private SolutionIndex<String> index;

    @Before
    public void setUp() throws Exception {
        this.now = System.currentTimeMillis();
        this.vars = new Query.QueryVariables(Arrays.asList("x", "y", "z"));
        int totalPatterns = 3;
        this.index = new SolutionIndex(this.vars, totalPatterns);
    }

    @Test
    public void testGetSolutions() throws Exception {
        Assert.assertEquals((long)0L, (long)this.count(this.index.getSolutions("x", (Object)"red", this.now)));
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("x", "red");
        map1.put("y", "green");
        Bindings b1 = new Bindings(map1, this.vars);
        Solution ps = new Solution(3, 0, b1, 0L);
        this.index.add(ps, this.now);
        Assert.assertEquals((long)1L, (long)this.count(this.index.getSolutions("x", (Object)"red", this.now)));
        Assert.assertEquals((long)0L, (long)this.count(this.index.getSolutions("x", (Object)"green", this.now)));
        Assert.assertEquals((long)0L, (long)this.count(this.index.getSolutions("y", (Object)"red", this.now)));
        Assert.assertEquals((long)1L, (long)this.count(this.index.getSolutions("y", (Object)"green", this.now)));
        map1 = new HashMap();
        map1.put("z", "blue");
        b1 = new Bindings(map1, this.vars);
        ps = new Solution(ps, 1, b1);
        this.index.add(ps, this.now);
        Assert.assertEquals((long)2L, (long)this.count(this.index.getSolutions("x", (Object)"red", this.now)));
        Assert.assertEquals((long)2L, (long)this.count(this.index.getSolutions("y", (Object)"green", this.now)));
        Assert.assertEquals((long)1L, (long)this.count(this.index.getSolutions("z", (Object)"blue", this.now)));
        map1 = new HashMap();
        map1.put("x", "red");
        map1.put("y", "green");
        b1 = new Bindings(map1, this.vars);
        ps = new Solution(3, 1, b1, 0L);
        this.index.add(ps, this.now);
        Assert.assertEquals((long)3L, (long)this.count(this.index.getSolutions("x", (Object)"red", this.now)));
        Assert.assertEquals((long)3L, (long)this.count(this.index.getSolutions("y", (Object)"green", this.now)));
        ps = new Solution(ps, 0);
        this.index.add(ps, this.now);
        Assert.assertEquals((long)2L, (long)this.count(this.index.getSolutions("x", (Object)"red", this.now)));
        Assert.assertEquals((long)2L, (long)this.count(this.index.getSolutions("y", (Object)"green", this.now)));
        map1 = new HashMap();
        map1.put("x", "puce");
        map1.put("y", "green");
        b1 = new Bindings(map1, this.vars);
        ps = new Solution(3, 0, b1, 0L);
        this.index.add(ps, this.now);
        Assert.assertEquals((long)2L, (long)this.count(this.index.getSolutions("x", (Object)"red", this.now)));
        Assert.assertEquals((long)1L, (long)this.count(this.index.getSolutions("x", (Object)"puce", this.now)));
        Assert.assertEquals((long)3L, (long)this.count(this.index.getSolutions("y", (Object)"green", this.now)));
    }

    @Test
    public void testGetExpiredSolutions() throws Exception {
        HashMap<String, String> bindingMap = new HashMap<String, String>();
        bindingMap.put("x", "red");
        bindingMap.put("y", "green");
        bindingMap.put("z", "blue");
        Bindings bindings1 = new Bindings(bindingMap, this.vars);
        bindingMap = new HashMap();
        bindingMap.put("x", "puce");
        bindingMap.put("y", "teal");
        Bindings bindings2 = new Bindings(bindingMap, this.vars);
        this.now = 42L;
        Solution solExp1_1 = new Solution(5, 0, bindings1, this.now + 10000L);
        Solution solExp1_2 = new Solution(new Solution(5, 1, bindings1, this.now + 5000L), 2);
        Solution solNonExp1_1 = new Solution(new Solution(5, 4, bindings1, 0L), 1);
        Solution solNonExp1_2 = new Solution(new Solution(5, 3, bindings1, 0L), 1);
        Solution solExp1_3 = new Solution(5, new Solution(5, 3, bindings1, 0L), new Solution(5, 4, bindings1, this.now + 20000L));
        Solution solExp2_1 = new Solution(5, 0, bindings2, this.now + 10000L);
        Solution solExp2_2 = new Solution(new Solution(5, 1, bindings2, this.now + 5000L), 2);
        Solution solExp2_3 = new Solution(5, new Solution(5, 3, bindings2, 0L), new Solution(5, 4, bindings2, this.now + 20000L));
        this.index.add(solExp1_1, this.now);
        this.index.add(solExp1_2, this.now);
        this.index.add(solNonExp1_1, this.now);
        this.index.add(solNonExp1_2, this.now);
        this.index.add(solExp1_3, this.now);
        this.index.add(solExp2_1, this.now);
        this.index.add(solExp2_2, this.now);
        this.index.add(solExp2_3, this.now);
        long then = this.now;
        Assert.assertEquals((long)5L, (long)this.count(this.index.getSolutions("x", (Object)"red", then)));
        Assert.assertEquals((long)5L, (long)this.count(this.index.getSolutions("y", (Object)"green", then)));
        Assert.assertEquals((long)5L, (long)this.count(this.index.getSolutions("z", (Object)"blue", then)));
        Assert.assertEquals((long)3L, (long)this.count(this.index.getSolutions("x", (Object)"puce", then)));
        Assert.assertEquals((long)3L, (long)this.count(this.index.getSolutions("y", (Object)"teal", then)));
        then = this.now + 5000L + 1L;
        Assert.assertEquals((long)4L, (long)this.count(this.index.getSolutions("x", (Object)"red", then)));
        Assert.assertEquals((long)4L, (long)this.count(this.index.getSolutions("y", (Object)"green", then)));
        Assert.assertEquals((long)4L, (long)this.count(this.index.getSolutions("z", (Object)"blue", then)));
        Assert.assertEquals((long)2L, (long)this.count(this.index.getSolutions("x", (Object)"puce", then)));
        Assert.assertEquals((long)2L, (long)this.count(this.index.getSolutions("y", (Object)"teal", then)));
        then = this.now + 10000L + 1L;
        Assert.assertEquals((long)3L, (long)this.count(this.index.getSolutions("x", (Object)"red", then)));
        Assert.assertEquals((long)3L, (long)this.count(this.index.getSolutions("y", (Object)"green", then)));
        Assert.assertEquals((long)3L, (long)this.count(this.index.getSolutions("z", (Object)"blue", then)));
        Assert.assertEquals((long)1L, (long)this.count(this.index.getSolutions("x", (Object)"puce", then)));
        Assert.assertEquals((long)1L, (long)this.count(this.index.getSolutions("y", (Object)"teal", then)));
        then = this.now + 20000L + 1L;
        Assert.assertEquals((long)2L, (long)this.count(this.index.getSolutions("x", (Object)"red", then)));
        Assert.assertEquals((long)2L, (long)this.count(this.index.getSolutions("y", (Object)"green", then)));
        Assert.assertEquals((long)2L, (long)this.count(this.index.getSolutions("z", (Object)"blue", then)));
        Assert.assertEquals((long)0L, (long)this.count(this.index.getSolutions("x", (Object)"puce", then)));
        Assert.assertEquals((long)0L, (long)this.count(this.index.getSolutions("y", (Object)"teal", then)));
    }

    @Test
    public void testGetComplementarySolutions() throws Exception {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("x", "red");
        map1.put("z", "blue");
        Bindings b1 = new Bindings(map1, this.vars);
        Solution ps1 = new Solution(3, 0, b1, 0L);
        Assert.assertEquals((long)0L, (long)this.count(this.index.getComposableSolutions("x", (Object)"red", ps1, this.now)));
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("x", "puce");
        map2.put("y", "green");
        Bindings b2 = new Bindings(map2, this.vars);
        Solution ps2 = new Solution(3, 1, b2, 0L);
        this.index.add(ps2, this.now);
        Assert.assertEquals((long)0L, (long)this.count(this.index.getComposableSolutions("x", (Object)"red", ps1, this.now)));
        map2 = new HashMap();
        map2.put("x", "red");
        map2.put("z", "green");
        b2 = new Bindings(map2, this.vars);
        ps2 = new Solution(3, 1, b2, 0L);
        this.index.add(ps2, this.now);
        Assert.assertEquals((long)0L, (long)this.count(this.index.getComposableSolutions("x", (Object)"red", ps1, this.now)));
        map2 = new HashMap();
        map2.put("y", "green");
        b2 = new Bindings(map2, this.vars);
        ps2 = new Solution(ps1, 2, b2);
        this.index.add(ps2, this.now);
        Assert.assertEquals((long)0L, (long)this.count(this.index.getComposableSolutions("x", (Object)"red", ps1, this.now)));
        map2 = new HashMap();
        map2.put("x", "red");
        map2.put("y", "green");
        b2 = new Bindings(map2, this.vars);
        ps2 = new Solution(3, 2, b2, 0L);
        this.index.add(ps2, this.now);
        Assert.assertEquals((long)1L, (long)this.count(this.index.getComposableSolutions("x", (Object)"red", ps1, this.now)));
    }

    @Test
    public void testComposeSolutions() throws Exception {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("x", "red");
        map1.put("z", "blue");
        Bindings b1 = new Bindings(map1, this.vars);
        Solution ps1 = new Solution(3, 0, b1, 0L);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("y", "green");
        Bindings b2 = new Bindings(map2, this.vars);
        Solution ps2 = new Solution(ps1, 2, b2);
        this.index.add(ps2, this.now);
        Assert.assertEquals((long)0L, (long)this.count(this.index.composeSolutions("x", (Object)"red", ps1, this.now)));
        map2 = new HashMap();
        map2.put("x", "red");
        map2.put("y", "green");
        b2 = new Bindings(map2, this.vars);
        ps2 = new Solution(3, 2, b2, 0L);
        this.index.add(ps2, this.now);
        Assert.assertEquals((long)1L, (long)this.count(this.index.composeSolutions("x", (Object)"red", ps1, this.now)));
        map2 = new HashMap();
        map2.put("x", "red");
        map2.put("y", "hazel");
        b2 = new Bindings(map2, this.vars);
        ps2 = new Solution(3, 2, b2, 0L);
        this.index.add(ps2, this.now);
        Assert.assertEquals((long)2L, (long)this.count(this.index.composeSolutions("x", (Object)"red", ps1, this.now)));
    }

    @Test
    public void testBindAndComposeSolutions() throws Exception {
        Stack solutions = new Stack();
        VariableOrConstant[] pattern = new VariableOrConstant[]{this.newTerm(null, "x"), this.newTerm("isRedderThan", null), this.newTerm(null, "z")};
        Object[] tuple = new String[]{"red", "isRedderThan", "blue"};
        Bindings b = this.vars.bind(pattern, tuple);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("x", "red");
        map1.put("z", "blue");
        Bindings b1 = new Bindings(map1, this.vars);
        Solution ps1 = new Solution(3, 0, b1, 0L);
        solutions.clear();
        this.index.joinSolutions(ps1, b, solutions, this.now);
        Assert.assertEquals((long)1L, (long)solutions.size());
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("x", "red");
        map2.put("y", "green");
        Bindings b2 = new Bindings(map2, this.vars);
        Solution ps2 = new Solution(3, 2, b2, 0L);
        this.index.add(ps2, this.now);
        solutions.clear();
        this.index.joinSolutions(ps1, b, solutions, this.now);
        Assert.assertEquals((long)2L, (long)solutions.size());
        map2 = new HashMap();
        map2.put("x", "red");
        map2.put("y", "hazel");
        b2 = new Bindings(map2, this.vars);
        ps2 = new Solution(3, 2, b2, 0L);
        this.index.add(ps2, this.now);
        solutions.clear();
        this.index.joinSolutions(ps1, b, solutions, this.now);
        Assert.assertEquals((long)3L, (long)solutions.size());
        map2 = new HashMap();
        map2.put("y", "green");
        b2 = new Bindings(map2, this.vars);
        ps2 = new Solution(3, 2, b2, 0L);
        this.index.add(ps2, this.now);
        solutions.clear();
        this.index.joinSolutions(ps1, b, solutions, this.now);
        Assert.assertEquals((long)3L, (long)solutions.size());
        map2 = new HashMap();
        map2.put("y", "green");
        map2.put("z", "blue");
        b2 = new Bindings(map2, this.vars);
        ps2 = new Solution(3, 1, b2, 0L);
        this.index.add(ps2, this.now);
        solutions.clear();
        this.index.joinSolutions(ps1, b, solutions, this.now);
        Assert.assertEquals((long)5L, (long)solutions.size());
        Map solutionMap = this.toMap(solutions);
        Assert.assertEquals((long)3L, (long)solutionMap.size());
        map1.clear();
        map1.put("x", "red");
        map1.put("y", "green");
        map1.put("z", "blue");
        b1 = new Bindings(map1, this.vars);
        Solution ps = solutionMap.get(b1.getHash());
        Assert.assertNotNull(ps);
        Assert.assertEquals((long)1L, (long)ps.remainingPatterns);
    }

    @Test
    public void testRemoveExpiredSolutions() throws Exception {
        HashMap<String, String> bindingMap = new HashMap<String, String>();
        bindingMap.put("x", "red");
        bindingMap.put("y", "green");
        bindingMap.put("z", "blue");
        Bindings bindings1 = new Bindings(bindingMap, this.vars);
        bindingMap = new HashMap();
        bindingMap.put("x", "puce");
        bindingMap.put("y", "teal");
        Bindings bindings2 = new Bindings(bindingMap, this.vars);
        this.now = 42L;
        long then = 1L;
        Solution solExp1_1 = new Solution(5, 0, bindings1, this.now + 10000L);
        Solution solExp1_2 = new Solution(new Solution(5, 1, bindings1, this.now + 5000L), 2);
        Solution solNonExp1_1 = new Solution(new Solution(5, 4, bindings1, 0L), 1);
        Solution solNonExp1_2 = new Solution(new Solution(5, 3, bindings1, 0L), 1);
        Solution solExp1_3 = new Solution(5, new Solution(5, 3, bindings1, 0L), new Solution(5, 4, bindings1, this.now + 20000L));
        Solution solExp2_1 = new Solution(5, 0, bindings2, this.now + 10000L);
        Solution solExp2_2 = new Solution(new Solution(5, 1, bindings2, this.now + 5000L), 2);
        Solution solExp2_3 = new Solution(5, new Solution(5, 3, bindings2, 0L), new Solution(5, 4, bindings2, this.now + 20000L));
        this.index.add(solExp1_1, this.now);
        this.index.add(solExp1_2, this.now);
        this.index.add(solNonExp1_1, this.now);
        this.index.add(solNonExp1_2, this.now);
        this.index.add(solExp1_3, this.now);
        this.index.add(solExp2_1, this.now);
        this.index.add(solExp2_2, this.now);
        this.index.add(solExp2_3, this.now);
        Assert.assertEquals((long)5L, (long)this.count(this.index.getSolutions("x", (Object)"red", then)));
        Assert.assertEquals((long)5L, (long)this.count(this.index.getSolutions("y", (Object)"green", then)));
        Assert.assertEquals((long)5L, (long)this.count(this.index.getSolutions("z", (Object)"blue", then)));
        Assert.assertEquals((long)3L, (long)this.count(this.index.getSolutions("x", (Object)"puce", then)));
        Assert.assertEquals((long)3L, (long)this.count(this.index.getSolutions("y", (Object)"teal", then)));
        this.index.removeExpired(this.now);
        Assert.assertEquals((long)5L, (long)this.count(this.index.getSolutions("x", (Object)"red", then)));
        Assert.assertEquals((long)5L, (long)this.count(this.index.getSolutions("y", (Object)"green", then)));
        Assert.assertEquals((long)5L, (long)this.count(this.index.getSolutions("z", (Object)"blue", then)));
        Assert.assertEquals((long)3L, (long)this.count(this.index.getSolutions("x", (Object)"puce", then)));
        Assert.assertEquals((long)3L, (long)this.count(this.index.getSolutions("y", (Object)"teal", then)));
        this.now += 6000L;
        this.index.removeExpired(this.now);
        Assert.assertEquals((long)4L, (long)this.count(this.index.getSolutions("x", (Object)"red", then)));
        Assert.assertEquals((long)4L, (long)this.count(this.index.getSolutions("y", (Object)"green", then)));
        Assert.assertEquals((long)4L, (long)this.count(this.index.getSolutions("z", (Object)"blue", then)));
        Assert.assertEquals((long)2L, (long)this.count(this.index.getSolutions("x", (Object)"puce", then)));
        Assert.assertEquals((long)2L, (long)this.count(this.index.getSolutions("y", (Object)"teal", then)));
        this.now += 5000L;
        this.index.removeExpired(this.now);
        Assert.assertEquals((long)3L, (long)this.count(this.index.getSolutions("x", (Object)"red", then)));
        Assert.assertEquals((long)3L, (long)this.count(this.index.getSolutions("y", (Object)"green", then)));
        Assert.assertEquals((long)3L, (long)this.count(this.index.getSolutions("z", (Object)"blue", then)));
        Assert.assertEquals((long)1L, (long)this.count(this.index.getSolutions("x", (Object)"puce", then)));
        Assert.assertEquals((long)1L, (long)this.count(this.index.getSolutions("y", (Object)"teal", then)));
        this.now += 10000L;
        this.index.removeExpired(this.now);
        Assert.assertEquals((long)2L, (long)this.count(this.index.getSolutions("x", (Object)"red", then)));
        Assert.assertEquals((long)2L, (long)this.count(this.index.getSolutions("y", (Object)"green", then)));
        Assert.assertEquals((long)2L, (long)this.count(this.index.getSolutions("z", (Object)"blue", then)));
        Assert.assertNull((Object)this.index.getSolutions("x", (Object)"puce", then));
        Assert.assertNull((Object)this.index.getSolutions("y", (Object)"teal", then));
    }

    private <T> int count(Iterator<T> iter) {
        int c = 0;
        if (null != iter) {
            while (iter.hasNext()) {
                ++c;
                iter.next();
            }
        }
        return c;
    }

    private <T> Map<Integer, Solution<T>> toMap(Stack<Solution<T>> solutions) {
        HashMap<Integer, Solution<T>> map = new HashMap<Integer, Solution<T>>();
        for (Solution solution : solutions) {
            int hash = solution.getBindings().getHash();
            map.put(hash, solution);
        }
        return map;
    }

    private VariableOrConstant<String, String> newTerm(String constant, String variable) {
        return new VariableOrConstant((Object)variable, (Object)constant);
    }
}

